/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.metadata.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.metadata.ModifiableBinaryMetadata;
import org.ametys.plugins.repository.metadata.jcr.JCROutputStream;
import org.ametys.plugins.repository.metadata.jcr.JCRResource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JCRBinaryMetadata
extends JCRResource
implements ModifiableBinaryMetadata {
    private static Logger __logger = LoggerFactory.getLogger(JCRBinaryMetadata.class);

    public JCRBinaryMetadata(Node node) {
        super(node);
    }

    @Override
    public String getFilename() {
        try {
            return this.getNode().getProperty("ametys:filename").getString();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void setFilename(String filename) {
        try {
            this.getNode().setProperty("ametys:filename", filename);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public String getHash() {
        try {
            return this.getNode().getProperty("ametys-internal:hash").getString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public void setInputStream(InputStream stream) throws AmetysRepositoryException {
        try {
            this._checkLock();
            Binary binary = this.getNode().getSession().getValueFactory().createBinary(stream);
            this.getNode().setProperty("jcr:data", binary);
            try (InputStream binaryStream = binary.getStream();){
                String sha1Hex = DigestUtils.sha1Hex((InputStream)binaryStream);
                this.getNode().setProperty("ametys-internal:hash", sha1Hex);
            }
            catch (IOException e) {
                __logger.warn("An error occurred setting the hash of binary", (Throwable)e);
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() throws AmetysRepositoryException {
        return new JCROutputStream(this.getNode(), true);
    }
}

