/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.metadata.jcr;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.metadata.CompositeMetadata;
import org.ametys.plugins.repository.metadata.ModifiableBinaryMetadata;
import org.ametys.plugins.repository.metadata.ModifiableCompositeMetadata;
import org.ametys.plugins.repository.metadata.ModifiableFile;
import org.ametys.plugins.repository.metadata.ModifiableFolder;
import org.ametys.plugins.repository.metadata.ModifiableResource;
import org.ametys.plugins.repository.metadata.ModifiableRichText;
import org.ametys.plugins.repository.metadata.MultilingualString;
import org.ametys.plugins.repository.metadata.UnknownMetadataException;
import org.ametys.plugins.repository.metadata.jcr.JCRBinaryMetadata;
import org.ametys.plugins.repository.metadata.jcr.JCRRichText;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class JCRCompositeMetadata
implements ModifiableCompositeMetadata {
    public static final String METADATA_PREFIX = "ametys:";
    public static final String OBJECT_COLLECTION_METADATA_NODETYPE = "ametys:objectCollectionMetadata";
    public static final String MULTILINGUAL_STRING_METADATA_NODETYPE = "ametys:multilingualString";
    private static Pattern __metadataNamePattern;
    private Node _node;
    private boolean _lockAlreadyChecked;
    private AmetysObjectResolver _resolver;

    public JCRCompositeMetadata(Node metadataNode, AmetysObjectResolver resolver) {
        this._node = metadataNode;
        this._resolver = resolver;
    }

    public Node getNode() {
        return this._node;
    }

    @Override
    public boolean hasMetadata(String metadataName) throws AmetysRepositoryException {
        try {
            NodeIterator it;
            boolean isEmpty;
            if (this._node.hasProperty(METADATA_PREFIX + metadataName)) {
                Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
                if (property.getDefinition().isMultiple()) {
                    return true;
                }
                CompositeMetadata.MetadataType type = this.getType(metadataName);
                switch (type) {
                    case STRING: {
                        return !"".equals(property.getString());
                    }
                }
                return true;
            }
            boolean hasNode = this._node.hasNode(METADATA_PREFIX + metadataName);
            if (!hasNode) {
                return false;
            }
            Node childNode = this._node.getNode(METADATA_PREFIX + metadataName);
            boolean bl = isEmpty = childNode.hasProperty("ametys-internal:isEmpty") && childNode.getProperty("ametys-internal:isEmpty").getBoolean();
            if (isEmpty) {
                return false;
            }
            if (NodeTypeHelper.isNodeType(childNode, "ametys:multipleItem") && (it = childNode.getNodes("ametys:*")).getSize() == 0L) {
                return false;
            }
            if (NodeTypeHelper.isNodeType(childNode, "ametys:user")) {
                try {
                    String login = childNode.getProperty("ametys:login").getString();
                    String population = childNode.getProperty("ametys:population").getString();
                    if (StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)population)) {
                        return false;
                    }
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
            if (NodeTypeHelper.isNodeType(childNode, "ametys:geocode")) {
                try {
                    return childNode.hasProperty("ametys:latitude") && childNode.hasProperty("ametys:longitude");
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
            return true;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void rename(String newName) throws AmetysRepositoryException {
        try {
            this.getNode().getSession().move(this.getNode().getPath(), this.getNode().getParent().getPath() + "/" + newName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void removeMetadata(String metadataName) throws AmetysRepositoryException {
        block5: {
            try {
                this._checkLock();
                String realMetadataName = METADATA_PREFIX + metadataName;
                if (this._node.hasProperty(realMetadataName)) {
                    this._node.getProperty(realMetadataName).remove();
                    break block5;
                }
                if (this._node.hasNode(realMetadataName)) {
                    NodeIterator it = this._node.getNodes(realMetadataName);
                    while (it.hasNext()) {
                        Node next = it.nextNode();
                        next.remove();
                    }
                    break block5;
                }
                throw new UnknownMetadataException("No metadata for name: " + metadataName);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException("Unable to remove metadata " + metadataName, e);
            }
        }
    }

    @Override
    public void copyTo(ModifiableCompositeMetadata metadata) throws AmetysRepositoryException {
        String[] metadataNames;
        block11: for (String metadataName : metadataNames = this.getMetadataNames()) {
            if (!this.hasMetadata(metadataName)) continue;
            CompositeMetadata.MetadataType type = this.getType(metadataName);
            boolean multiple = this.isMultiple(metadataName);
            switch (type) {
                case COMPOSITE: {
                    ModifiableCompositeMetadata compositeMetadata = metadata.getCompositeMetadata(metadataName, true);
                    this.getCompositeMetadata(metadataName).copyTo(compositeMetadata);
                    continue block11;
                }
                case USER: {
                    if (multiple) {
                        metadata.setMetadata(metadataName, this.getUserArray(metadataName));
                        continue block11;
                    }
                    metadata.setMetadata(metadataName, this.getUser(metadataName));
                    continue block11;
                }
                case BOOLEAN: {
                    if (multiple) {
                        metadata.setMetadata(metadataName, this.getBooleanArray(metadataName));
                        continue block11;
                    }
                    metadata.setMetadata(metadataName, this.getBoolean(metadataName));
                    continue block11;
                }
                case DATE: {
                    if (multiple) {
                        metadata.setMetadata(metadataName, this.getDateArray(metadataName));
                        continue block11;
                    }
                    metadata.setMetadata(metadataName, this.getDate(metadataName));
                    continue block11;
                }
                case DOUBLE: {
                    if (multiple) {
                        metadata.setMetadata(metadataName, this.getDoubleArray(metadataName));
                        continue block11;
                    }
                    metadata.setMetadata(metadataName, this.getDouble(metadataName));
                    continue block11;
                }
                case LONG: {
                    if (multiple) {
                        metadata.setMetadata(metadataName, this.getLongArray(metadataName));
                        continue block11;
                    }
                    metadata.setMetadata(metadataName, this.getLong(metadataName));
                    continue block11;
                }
                case BINARY: {
                    ModifiableBinaryMetadata binaryMetadata = metadata.getBinaryMetadata(metadataName, true);
                    ModifiableBinaryMetadata srcBinary = this.getBinaryMetadata(metadataName);
                    binaryMetadata.setFilename(srcBinary.getFilename());
                    binaryMetadata.setMimeType(srcBinary.getMimeType());
                    binaryMetadata.setLastModified(srcBinary.getLastModified());
                    binaryMetadata.setEncoding(srcBinary.getEncoding());
                    binaryMetadata.setInputStream(srcBinary.getInputStream());
                    continue block11;
                }
                case RICHTEXT: {
                    ModifiableRichText richText = metadata.getRichText(metadataName, true);
                    ModifiableRichText srcRichText = this.getRichText(metadataName);
                    richText.setInputStream(srcRichText.getInputStream());
                    richText.setEncoding(srcRichText.getEncoding());
                    richText.setLastModified(srcRichText.getLastModified());
                    richText.setMimeType(srcRichText.getMimeType());
                    this._copyDataFolder(srcRichText.getAdditionalDataFolder(), richText.getAdditionalDataFolder());
                    continue block11;
                }
                case MULTILINGUAL_STRING: {
                    MultilingualString srcMultilingualString = this.getMultilingualString(metadataName);
                    metadata.setMetadata(metadataName, srcMultilingualString);
                    continue block11;
                }
                default: {
                    if (multiple) {
                        metadata.setMetadata(metadataName, this.getStringArray(metadataName));
                        continue block11;
                    }
                    metadata.setMetadata(metadataName, this.getString(metadataName));
                }
            }
        }
    }

    private void _copyDataFolder(ModifiableFolder srcDataFolder, ModifiableFolder targetDataFolder) {
        Collection<ModifiableFolder> folders = srcDataFolder.getFolders();
        for (ModifiableFolder srcSubfolder : folders) {
            ModifiableFolder targetSubFolder = targetDataFolder.addFolder(srcSubfolder.getName());
            this._copyDataFolder(srcSubfolder, targetSubFolder);
        }
        Collection<ModifiableFile> files = srcDataFolder.getFiles();
        for (ModifiableFile srcFile : files) {
            this._copyFile(srcFile, targetDataFolder);
        }
    }

    private void _copyFile(ModifiableFile srcFile, ModifiableFolder targetDataFolder) {
        ModifiableResource srcResource = srcFile.getResource();
        ModifiableFile targetFile = targetDataFolder.addFile(srcFile.getName());
        ModifiableResource targetResource = targetFile.getResource();
        targetResource.setLastModified(srcResource.getLastModified());
        targetResource.setMimeType(srcResource.getMimeType());
        targetResource.setEncoding(srcResource.getEncoding());
        targetResource.setInputStream(srcResource.getInputStream());
    }

    @Override
    public CompositeMetadata.MetadataType getType(String metadataName) throws AmetysRepositoryException {
        try {
            String realMetadataName = METADATA_PREFIX + metadataName;
            if (this._node.hasNode(realMetadataName)) {
                Node node = this._node.getNode(realMetadataName);
                String type = node.getPrimaryNodeType().getName();
                if ("nt:frozenNode".equals(this._node.getPrimaryNodeType().getName())) {
                    type = node.getProperty("jcr:frozenPrimaryType").getString();
                }
                if (type.equals(OBJECT_COLLECTION_METADATA_NODETYPE)) {
                    return CompositeMetadata.MetadataType.OBJECT_COLLECTION;
                }
                if (type.equals("ametys:binaryMetadata")) {
                    return CompositeMetadata.MetadataType.BINARY;
                }
                if (type.equals("ametys:richText")) {
                    return CompositeMetadata.MetadataType.RICHTEXT;
                }
                if (type.equals("ametys:user")) {
                    return CompositeMetadata.MetadataType.USER;
                }
                if (type.equals(MULTILINGUAL_STRING_METADATA_NODETYPE)) {
                    return CompositeMetadata.MetadataType.MULTILINGUAL_STRING;
                }
                return CompositeMetadata.MetadataType.COMPOSITE;
            }
            if (this._node.hasProperty(realMetadataName)) {
                Property property = this._node.getProperty(realMetadataName);
                int type = property.getType();
                switch (type) {
                    case 1: {
                        return CompositeMetadata.MetadataType.STRING;
                    }
                    case 6: {
                        return CompositeMetadata.MetadataType.BOOLEAN;
                    }
                    case 5: {
                        return CompositeMetadata.MetadataType.DATE;
                    }
                    case 4: {
                        return CompositeMetadata.MetadataType.DOUBLE;
                    }
                    case 3: {
                        return CompositeMetadata.MetadataType.LONG;
                    }
                }
                throw new AmetysRepositoryException("Unhandled JCR property type : " + PropertyType.nameFromValue((int)type));
            }
            throw new UnknownMetadataException("No metadata for name: " + metadataName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get property type", e);
        }
    }

    @Override
    public String getString(String metadataName) {
        return this._getString(metadataName, null, true);
    }

    @Override
    public String getString(String metadataName, String defaultValue) {
        return this._getString(metadataName, defaultValue, false);
    }

    private String _getString(String metadataName, String defaultValue, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                if (values.length > 0) {
                    return values[0].getString();
                }
                throw new AmetysRepositoryException("Cannot get a String from an empty array");
            }
            return property.getString();
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValue;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get String property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public String[] getStringArray(String metadataName) throws AmetysRepositoryException {
        return this._getStringArray(metadataName, null, true);
    }

    @Override
    public String[] getStringArray(String metadataName, String[] defaultValues) {
        return this._getStringArray(metadataName, defaultValues, false);
    }

    private String[] _getStringArray(String metadataName, String[] defaultValues, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                String[] results = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    results[i] = value.getString();
                }
                return results;
            }
            Value value = property.getValue();
            return new String[]{value.getString()};
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValues;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get String array property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public String getLocalizedString(String metadataName, Locale locale) throws UnknownMetadataException, AmetysRepositoryException {
        return this._getString(metadataName, locale, null, true);
    }

    @Override
    public String getLocalizedString(String metadataName, Locale locale, String defaultValue) throws AmetysRepositoryException {
        return this._getString(metadataName, locale, defaultValue, false);
    }

    @Override
    public MultilingualString getMultilingualString(String metadataName) throws AmetysRepositoryException {
        try {
            if (this._node.hasNode(METADATA_PREFIX + metadataName)) {
                Node node = this._node.getNode(METADATA_PREFIX + metadataName);
                MultilingualString values = new MultilingualString();
                PropertyIterator properties = node.getProperties("ametys:*");
                while (properties.hasNext()) {
                    Property property = properties.nextProperty();
                    String name = property.getName().substring(METADATA_PREFIX.length());
                    try {
                        Locale locale = LocaleUtils.toLocale((String)name);
                        values.add(locale, property.getString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                return values;
            }
            throw new UnknownMetadataException("No multilingual String named " + metadataName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get multilingual String property", e);
        }
    }

    private String _getString(String metadataName, Locale locale, String defaultValue, boolean failIfNotExist) {
        try {
            Node node = this._node.getNode(METADATA_PREFIX + metadataName);
            Property property = node.getProperty(METADATA_PREFIX + locale.toString());
            return property.getString();
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValue;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get String property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public boolean getBoolean(String metadataName) throws UnknownMetadataException, AmetysRepositoryException {
        return this._getBoolean(metadataName, null, true);
    }

    @Override
    public boolean getBoolean(String metadataName, boolean defaultValue) throws AmetysRepositoryException {
        return this._getBoolean(metadataName, defaultValue, false);
    }

    private boolean _getBoolean(String metadataName, Boolean defaultValue, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                if (values.length > 0) {
                    return values[0].getBoolean();
                }
                throw new AmetysRepositoryException("Cannot get a boolean from an empty array");
            }
            return property.getBoolean();
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValue;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get boolean property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public boolean[] getBooleanArray(String metadataName) throws AmetysRepositoryException {
        return this._getBooleanArray(metadataName, null, true);
    }

    @Override
    public boolean[] getBooleanArray(String metadataName, boolean[] defaultValues) {
        return this._getBooleanArray(metadataName, defaultValues, false);
    }

    private boolean[] _getBooleanArray(String metadataName, boolean[] defaultValues, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                boolean[] results = new boolean[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    results[i] = value.getBoolean();
                }
                return results;
            }
            Value value = property.getValue();
            return new boolean[]{value.getBoolean()};
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValues;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get boolean array property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public Date getDate(String metadataName) throws AmetysRepositoryException {
        return this._getDate(metadataName, null, true);
    }

    @Override
    public Date getDate(String metadataName, Date defaultValue) throws AmetysRepositoryException {
        return this._getDate(metadataName, defaultValue, false);
    }

    private Date _getDate(String metadataName, Date defaultValue, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                if (values.length > 0) {
                    return values[0].getDate().getTime();
                }
                throw new AmetysRepositoryException("Cannot get a date from an empty array");
            }
            return property.getDate().getTime();
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValue;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get date property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public Date[] getDateArray(String metadataName) throws AmetysRepositoryException {
        return this._getDateArray(metadataName, null, true);
    }

    @Override
    public Date[] getDateArray(String metadataName, Date[] defaultValues) {
        return this._getDateArray(metadataName, defaultValues, false);
    }

    private Date[] _getDateArray(String metadataName, Date[] defaultValues, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                Date[] results = new Date[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    results[i] = value.getDate().getTime();
                }
                return results;
            }
            Value value = property.getValue();
            return new Date[]{value.getDate().getTime()};
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValues;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get date array property", e);
        }
    }

    @Override
    public long getLong(String metadataName) throws AmetysRepositoryException {
        return this._getLong(metadataName, null, true);
    }

    @Override
    public long getLong(String metadataName, long defaultValue) throws AmetysRepositoryException {
        return this._getLong(metadataName, defaultValue, false);
    }

    private long _getLong(String metadataName, Long defaultValue, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                if (values.length > 0) {
                    return values[0].getLong();
                }
                throw new AmetysRepositoryException("Cannot get a long from an empty array");
            }
            return property.getLong();
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValue;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get long property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public long[] getLongArray(String metadataName) throws AmetysRepositoryException {
        return this._getLongArray(metadataName, null, true);
    }

    @Override
    public long[] getLongArray(String metadataName, long[] defaultValues) {
        return this._getLongArray(metadataName, defaultValues, false);
    }

    private long[] _getLongArray(String metadataName, long[] defaultValues, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                long[] results = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    results[i] = value.getLong();
                }
                return results;
            }
            Value value = property.getValue();
            return new long[]{value.getLong()};
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValues;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get long array property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public double getDouble(String metadataName) throws AmetysRepositoryException {
        return this._getDouble(metadataName, null, true);
    }

    @Override
    public double getDouble(String metadataName, double defaultValue) throws AmetysRepositoryException {
        return this._getDouble(metadataName, defaultValue, false);
    }

    private double _getDouble(String metadataName, Double defaultValue, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                if (values.length > 0) {
                    return values[0].getDouble();
                }
                throw new AmetysRepositoryException("Cannot get a double from an empty array");
            }
            return property.getDouble();
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValue;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get double property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public double[] getDoubleArray(String metadataName) throws AmetysRepositoryException {
        return this._getDoubleArray(metadataName, null, true);
    }

    @Override
    public double[] getDoubleArray(String metadataName, double[] defaultValues) {
        return this._getDoubleArray(metadataName, defaultValues, false);
    }

    private double[] _getDoubleArray(String metadataName, double[] defaultValues, boolean failIfNotExist) {
        try {
            Property property = this._node.getProperty(METADATA_PREFIX + metadataName);
            if (property.getDefinition().isMultiple()) {
                Value[] values = property.getValues();
                double[] results = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Value value = values[i];
                    results[i] = value.getDouble();
                }
                return results;
            }
            Value value = property.getValue();
            return new double[]{value.getDouble()};
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValues;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get double array property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public UserIdentity getUser(String metadataName) throws AmetysRepositoryException {
        return this._getUser(metadataName, null, true);
    }

    @Override
    public UserIdentity getUser(String metadataName, UserIdentity defaultValue) throws AmetysRepositoryException {
        return this._getUser(metadataName, defaultValue, false);
    }

    private UserIdentity _getUser(String metadataName, UserIdentity defaultValue, boolean failIfNotExist) throws AmetysRepositoryException {
        try {
            Node userNode = this._node.getNode(METADATA_PREFIX + metadataName);
            String login = userNode.getProperty("ametys:login").getString();
            String population = userNode.getProperty("ametys:population").getString();
            if (StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)population)) {
                if (failIfNotExist) {
                    throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node));
                }
                return defaultValue;
            }
            return new UserIdentity(login, population);
        }
        catch (PathNotFoundException e) {
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node), e);
            }
            return defaultValue;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get User property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public UserIdentity[] getUserArray(String metadataName) throws AmetysRepositoryException {
        return this._getUserArray(metadataName, null, true);
    }

    @Override
    public UserIdentity[] getUserArray(String metadataName, UserIdentity[] defaultValues) throws AmetysRepositoryException {
        return this._getUserArray(metadataName, defaultValues, false);
    }

    private UserIdentity[] _getUserArray(String metadataName, UserIdentity[] defaultValues, boolean failIfNotExist) throws AmetysRepositoryException {
        try {
            if (this._node.hasNode(METADATA_PREFIX + metadataName)) {
                ArrayList<UserIdentity> results = new ArrayList<UserIdentity>();
                if (NodeTypeHelper.isNodeType(this._node.getNode(METADATA_PREFIX + metadataName), "ametys:user")) {
                    NodeIterator it = this._node.getNodes(METADATA_PREFIX + metadataName);
                    while (it.hasNext()) {
                        Node next = (Node)it.next();
                        String login = next.getProperty("ametys:login").getString();
                        String population = next.getProperty("ametys:population").getString();
                        if (StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)population)) {
                            if (failIfNotExist) {
                                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node));
                            }
                            return defaultValues;
                        }
                        results.add(new UserIdentity(login, population));
                    }
                } else if (NodeTypeHelper.isNodeType(this._node.getNode(METADATA_PREFIX + metadataName), "ametys:multipleItem")) {
                    Node multipleItemNode = this._node.getNode(METADATA_PREFIX + metadataName);
                    NodeIterator it = multipleItemNode.getNodes("ametys:*");
                    while (it.hasNext()) {
                        Node next = it.nextNode();
                        if (!NodeTypeHelper.isNodeType(next, "ametys:user")) continue;
                        String login = next.getProperty("ametys:login").getString();
                        String population = next.getProperty("ametys:population").getString();
                        if (StringUtils.isEmpty((CharSequence)login) || StringUtils.isEmpty((CharSequence)population)) {
                            if (failIfNotExist) {
                                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node));
                            }
                            return defaultValues;
                        }
                        results.add(new UserIdentity(login, population));
                    }
                }
                return results.toArray(new UserIdentity[results.size()]);
            }
            if (failIfNotExist) {
                throw new UnknownMetadataException("Unknown metadata ametys:" + metadataName + " of " + String.valueOf(this._node));
            }
            return defaultValues;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get User array property: ametys:" + metadataName + " of " + String.valueOf(this._node), e);
        }
    }

    @Override
    public void setMetadata(String metadataName, String value) throws AmetysRepositoryException {
        if (value == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            this._node.setProperty(METADATA_PREFIX + metadataName, value);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, String[] value) throws AmetysRepositoryException {
        if (value == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            this._node.setProperty(METADATA_PREFIX + metadataName, value);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, String value, Locale locale) throws AmetysRepositoryException {
        if (value == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            Node node = null;
            node = this._node.hasNode(METADATA_PREFIX + metadataName) ? this._node.getNode(METADATA_PREFIX + metadataName) : this._node.addNode(METADATA_PREFIX + metadataName, MULTILINGUAL_STRING_METADATA_NODETYPE);
            node.setProperty(METADATA_PREFIX + locale.toString(), value);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, Date value) throws AmetysRepositoryException {
        if (value == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        GregorianCalendar calendar = GregorianCalendar.from(Instant.ofEpochMilli(value.getTime()).atZone(ZoneOffset.UTC));
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            this._node.setProperty(METADATA_PREFIX + metadataName, (Calendar)calendar);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, Date[] values) throws AmetysRepositoryException {
        if (values == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                Date value = values[i];
                GregorianCalendar calendar = GregorianCalendar.from(Instant.ofEpochMilli(value.getTime()).atZone(ZoneOffset.UTC));
                jcrValues[i] = this._node.getSession().getValueFactory().createValue((Calendar)calendar);
            }
            this._node.setProperty(METADATA_PREFIX + metadataName, jcrValues);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, long value) throws AmetysRepositoryException {
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            this._node.setProperty(METADATA_PREFIX + metadataName, value);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, double value) throws AmetysRepositoryException {
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            this._node.setProperty(METADATA_PREFIX + metadataName, value);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, long[] values) throws AmetysRepositoryException {
        if (values == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                long value = values[i];
                jcrValues[i] = this._node.getSession().getValueFactory().createValue(value);
            }
            this._node.setProperty(METADATA_PREFIX + metadataName, jcrValues);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, double[] values) throws AmetysRepositoryException {
        if (values == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                double value = values[i];
                jcrValues[i] = this._node.getSession().getValueFactory().createValue(value);
            }
            this._node.setProperty(METADATA_PREFIX + metadataName, jcrValues);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, boolean value) throws AmetysRepositoryException {
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            this._node.setProperty(METADATA_PREFIX + metadataName, value);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, boolean[] values) throws AmetysRepositoryException {
        if (values == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            Value[] jcrValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                boolean value = values[i];
                jcrValues[i] = this._node.getSession().getValueFactory().createValue(value);
            }
            this._node.setProperty(METADATA_PREFIX + metadataName, jcrValues);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, UserIdentity value) throws AmetysRepositoryException {
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            Node userNode = null;
            userNode = this._node.hasNode(METADATA_PREFIX + metadataName) ? this._node.getNode(METADATA_PREFIX + metadataName) : this._node.addNode(METADATA_PREFIX + metadataName, "ametys:user");
            userNode.setProperty("ametys:login", value.getLogin());
            userNode.setProperty("ametys:population", value.getPopulationId());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, UserIdentity[] values) throws AmetysRepositoryException {
        if (values == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            NodeIterator it = this._node.getNodes(METADATA_PREFIX + metadataName);
            while (it.hasNext()) {
                Node next = (Node)it.next();
                next.remove();
            }
            for (UserIdentity value : values) {
                Node userNode = this._node.addNode(METADATA_PREFIX + metadataName, "ametys:user");
                userNode.setProperty("ametys:login", value.getLogin());
                userNode.setProperty("ametys:population", value.getPopulationId());
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public void setMetadata(String metadataName, MultilingualString value) throws AmetysRepositoryException {
        if (value == null) {
            throw new NullPointerException("metadata value cannot be null");
        }
        this._checkMetadataName(metadataName);
        try {
            this._checkLock();
            NodeIterator it = this._node.getNodes(METADATA_PREFIX + metadataName);
            while (it.hasNext()) {
                Node next = (Node)it.next();
                next.remove();
            }
            Node node = null;
            node = this._node.hasNode(METADATA_PREFIX + metadataName) ? this._node.getNode(METADATA_PREFIX + metadataName) : this._node.addNode(METADATA_PREFIX + metadataName, MULTILINGUAL_STRING_METADATA_NODETYPE);
            for (Locale locale : value.getLocales()) {
                node.setProperty(METADATA_PREFIX + locale.toString(), value.getValue(locale));
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set property", e);
        }
    }

    @Override
    public String[] getMetadataNames() throws AmetysRepositoryException {
        try {
            PropertyIterator itProp = this._node.getProperties("ametys:*");
            NodeIterator itNode = this._node.getNodes("ametys:*");
            HashSet<String> names = new HashSet<String>();
            while (itProp.hasNext()) {
                Property property = itProp.nextProperty();
                names.add(property.getName().substring(METADATA_PREFIX.length()));
            }
            while (itNode.hasNext()) {
                Node node = itNode.nextNode();
                if (NodeTypeHelper.isNodeType(node, "ametys:object") && !NodeTypeHelper.isNodeType(node, OBJECT_COLLECTION_METADATA_NODETYPE) && !NodeTypeHelper.isNodeType(node, "ametys:user") && !NodeTypeHelper.isNodeType(node, MULTILINGUAL_STRING_METADATA_NODETYPE)) continue;
                names.add(node.getName().substring(METADATA_PREFIX.length()));
            }
            String[] result = new String[names.size()];
            names.toArray(result);
            return result;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get metadata names", e);
        }
    }

    @Override
    public boolean isMultiple(String metadataName) throws AmetysRepositoryException {
        try {
            String realMetadataName = METADATA_PREFIX + metadataName;
            if (this._node.hasProperty(realMetadataName)) {
                Property property = this._node.getProperty(realMetadataName);
                return property.getDefinition().isMultiple();
            }
            if (this._node.hasNode(realMetadataName)) {
                String nodeType = NodeTypeHelper.getNodeTypeName(this._node.getNode(realMetadataName));
                if (OBJECT_COLLECTION_METADATA_NODETYPE.equals(nodeType)) {
                    return true;
                }
                if (nodeType.equals("ametys:user")) {
                    return this._node.getNodes(realMetadataName).getSize() > 1L;
                }
                return false;
            }
            throw new UnknownMetadataException("No metadata for name: " + metadataName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to determine if metadata " + metadataName + " is multiple", e);
        }
    }

    protected void _checkMetadataName(String metadataName) throws AmetysRepositoryException {
        if (metadataName == null) {
            throw new AmetysRepositoryException("Invalid metadata name (null)");
        }
        if (!JCRCompositeMetadata._getMetadataNamePattern().matcher(metadataName).matches()) {
            throw new AmetysRepositoryException("Invalid metadata name '" + metadataName + "'. This value is not permitted: only [a-zA-Z][a-zA-Z0-9-_]* are allowed.");
        }
    }

    protected static Pattern _getMetadataNamePattern() {
        if (__metadataNamePattern == null) {
            __metadataNamePattern = Pattern.compile("[a-z][a-z0-9-_]*", 2);
        }
        return __metadataNamePattern;
    }

    @Override
    public ModifiableBinaryMetadata getBinaryMetadata(String metadataName) throws AmetysRepositoryException {
        return this.getBinaryMetadata(metadataName, false);
    }

    @Override
    public ModifiableBinaryMetadata getBinaryMetadata(String metadataName, boolean createNew) throws AmetysRepositoryException {
        try {
            if (this._node.hasNode(METADATA_PREFIX + metadataName)) {
                Node node = this._node.getNode(METADATA_PREFIX + metadataName);
                return new JCRBinaryMetadata(node);
            }
            if (createNew) {
                this._checkLock();
                Node node = this._node.addNode(METADATA_PREFIX + metadataName, "ametys:binaryMetadata");
                return new JCRBinaryMetadata(node);
            }
            throw new UnknownMetadataException("No BinaryMetadata named " + metadataName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public ModifiableCompositeMetadata getCompositeMetadata(String metadataName) throws AmetysRepositoryException {
        return this.getCompositeMetadata(metadataName, false);
    }

    @Override
    public ModifiableCompositeMetadata getCompositeMetadata(String metadataName, boolean createNew) throws AmetysRepositoryException {
        try {
            if (this._node.hasNode(METADATA_PREFIX + metadataName)) {
                Node node = this._node.getNode(METADATA_PREFIX + metadataName);
                return new JCRCompositeMetadata(node, this._resolver);
            }
            if (createNew) {
                this._checkLock();
                Node node = this._node.addNode(METADATA_PREFIX + metadataName, "ametys:compositeMetadata");
                return new JCRCompositeMetadata(node, this._resolver);
            }
            throw new UnknownMetadataException("No CompositeMetadata named " + metadataName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public ModifiableRichText getRichText(String metadataName) throws UnknownMetadataException, AmetysRepositoryException {
        return this.getRichText(metadataName, false);
    }

    @Override
    public ModifiableRichText getRichText(String metadataName, boolean createNew) throws UnknownMetadataException, AmetysRepositoryException {
        try {
            if (this._node.hasNode(METADATA_PREFIX + metadataName)) {
                Node node = this._node.getNode(METADATA_PREFIX + metadataName);
                if (node.hasProperty("ametys-internal:isEmpty") && node.getProperty("ametys-internal:isEmpty").getBoolean()) {
                    throw new UnknownMetadataException("No RichText named " + metadataName);
                }
                return new JCRRichText(node, this._resolver);
            }
            if (createNew) {
                this._checkLock();
                Node node = this._node.addNode(METADATA_PREFIX + metadataName, "ametys:richText");
                return new JCRRichText(node, this._resolver);
            }
            throw new UnknownMetadataException("No RichText named " + metadataName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public ModifiableTraversableAmetysObject getObjectCollection(String metadataName) throws AmetysRepositoryException {
        return this.getObjectCollection(metadataName, false);
    }

    @Override
    public ModifiableTraversableAmetysObject getObjectCollection(String metadataName, boolean createNew) throws AmetysRepositoryException {
        try {
            if (this._node.hasNode(METADATA_PREFIX + metadataName)) {
                Node node = this._node.getNode(METADATA_PREFIX + metadataName);
                return (ModifiableTraversableAmetysObject)this._resolver.resolve(node, false);
            }
            if (createNew) {
                this._checkLock();
                Node node = this._node.addNode(METADATA_PREFIX + metadataName, OBJECT_COLLECTION_METADATA_NODETYPE);
                return (ModifiableTraversableAmetysObject)this._resolver.resolve(node, false);
            }
            throw new UnknownMetadataException("No object collection metadata named " + metadataName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    private void _checkLock() throws RepositoryException {
        if (!this._lockAlreadyChecked && this._node.isLocked()) {
            LockManager lockManager = this._node.getSession().getWorkspace().getLockManager();
            Lock lock = lockManager.getLock(this._node.getPath());
            Node lockHolder = lock.getNode();
            lockManager.addLockToken(lockHolder.getProperty("ametys-internal:lockToken").getString());
            this._lockAlreadyChecked = true;
        }
    }
}

