/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.metadata.jcr;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.metadata.ModifiableFile;
import org.ametys.plugins.repository.metadata.ModifiableFolder;
import org.ametys.plugins.repository.metadata.UnknownMetadataException;
import org.ametys.plugins.repository.metadata.jcr.JCRFile;
import org.apache.jackrabbit.util.Text;

@Deprecated
public class JCRFolder
implements ModifiableFolder {
    private Node _node;
    private boolean _lockAlreadyChecked;

    public JCRFolder(Node node) {
        this._node = node;
    }

    public Node getNode() {
        return this._node;
    }

    @Override
    public String getName() throws AmetysRepositoryException {
        try {
            return Text.unescapeIllegalJcrChars((String)this._node.getName());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public Collection<ModifiableFolder> getFolders() {
        ArrayList<ModifiableFolder> folders = new ArrayList<ModifiableFolder>();
        try {
            NodeIterator it = this._node.getNodes();
            while (it.hasNext()) {
                Node node = it.nextNode();
                if (!NodeTypeHelper.isNodeType(node, "nt:folder")) continue;
                folders.add(new JCRFolder(node));
            }
            return folders;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public ModifiableFolder getFolder(String folderName) {
        try {
            Node node = this._node.getNode(Text.escapeIllegalJcrChars((String)folderName));
            return new JCRFolder(node);
        }
        catch (PathNotFoundException e) {
            throw new UnknownMetadataException(e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public ModifiableFolder addFolder(String folderName) {
        try {
            this._checkLock();
            Node node = this._node.addNode(Text.escapeIllegalJcrChars((String)folderName), "nt:folder");
            return new JCRFolder(node);
        }
        catch (ItemExistsException e) {
            throw new RepositoryIntegrityViolationException(e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public Collection<ModifiableFile> getFiles() {
        ArrayList<ModifiableFile> files = new ArrayList<ModifiableFile>();
        try {
            NodeIterator it = this._node.getNodes();
            while (it.hasNext()) {
                Node node = it.nextNode();
                if (!NodeTypeHelper.isNodeType(node, "nt:file")) continue;
                files.add(new JCRFile(node));
            }
            return files;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public boolean hasFile(String fileName) throws AmetysRepositoryException {
        try {
            return this._node.hasNode(Text.escapeIllegalJcrChars((String)fileName));
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public ModifiableFile getFile(String fileName) {
        try {
            Node node = this._node.getNode(Text.escapeIllegalJcrChars((String)fileName));
            return new JCRFile(node);
        }
        catch (PathNotFoundException e) {
            throw new UnknownMetadataException(e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public ModifiableFile addFile(String fileName) {
        try {
            this._checkLock();
            Node node = this._node.addNode(Text.escapeIllegalJcrChars((String)fileName), "nt:file");
            return new JCRFile(node);
        }
        catch (ItemExistsException e) {
            throw new RepositoryIntegrityViolationException(e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void remove(String name) throws AmetysRepositoryException {
        try {
            this._checkLock();
            Node node = this._node.getNode(Text.escapeIllegalJcrChars((String)name));
            node.remove();
        }
        catch (PathNotFoundException e) {
            throw new UnknownMetadataException(e);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void removeAll() throws AmetysRepositoryException {
        try {
            this._checkLock();
            NodeIterator it = this._node.getNodes();
            while (it.hasNext()) {
                Node node = it.nextNode();
                node.remove();
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    private void _checkLock() throws RepositoryException {
        if (!this._lockAlreadyChecked && this._node.isLocked()) {
            Lock lock = this._node.getSession().getWorkspace().getLockManager().getLock(this._node.getPath());
            Node lockHolder = lock.getNode();
            lockHolder.getSession().getWorkspace().getLockManager().addLockToken(lockHolder.getProperty("ametys-internal:lockToken").getString());
            this._lockAlreadyChecked = true;
        }
    }
}

