/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.metadata.jcr;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.metadata.ModifiableResource;
import org.ametys.plugins.repository.metadata.jcr.JCROutputStream;

@Deprecated
public class JCRResource
implements ModifiableResource {
    private Node _node;
    private boolean _lockAlreadyChecked;

    public JCRResource(Node node) {
        this._node = node;
    }

    public Node getNode() {
        return this._node;
    }

    @Override
    public void rename(String newName) throws AmetysRepositoryException {
        try {
            this._checkLock();
            this.getNode().getSession().move(this.getNode().getPath(), this.getNode().getParent().getPath() + "/" + newName);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public String getEncoding() throws AmetysRepositoryException {
        try {
            return this._node.getProperty("jcr:encoding").getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public InputStream getInputStream() throws AmetysRepositoryException {
        try {
            return this._node.getProperty("jcr:data").getBinary().getStream();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public Date getLastModified() throws AmetysRepositoryException {
        try {
            return this._node.getProperty("jcr:lastModified").getDate().getTime();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public long getLength() throws AmetysRepositoryException {
        try {
            return this._node.getProperty("jcr:data").getLength();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public String getMimeType() throws AmetysRepositoryException {
        try {
            return this._node.getProperty("jcr:mimeType").getString();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void setEncoding(String encoding) throws AmetysRepositoryException {
        try {
            this._checkLock();
            this._node.setProperty("jcr:encoding", encoding);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void setInputStream(InputStream stream) throws AmetysRepositoryException {
        try {
            this._checkLock();
            Binary binary = this._node.getSession().getValueFactory().createBinary(stream);
            this._node.setProperty("jcr:data", binary);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void setLastModified(Date lastModifiedDate) throws AmetysRepositoryException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(lastModifiedDate);
        try {
            this._checkLock();
            this._node.setProperty("jcr:lastModified", (Calendar)gc);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public void setMimeType(String mimeType) throws AmetysRepositoryException {
        try {
            this._checkLock();
            this._node.setProperty("jcr:mimeType", mimeType);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() throws AmetysRepositoryException {
        return new JCROutputStream(this._node, false);
    }

    protected void _checkLock() throws RepositoryException {
        if (!this._lockAlreadyChecked && this._node.isLocked()) {
            Lock lock = this._node.getSession().getWorkspace().getLockManager().getLock(this._node.getPath());
            Node lockHolder = lock.getNode();
            lockHolder.getSession().getWorkspace().getLockManager().addLockToken(lockHolder.getProperty("ametys-internal:lockToken").getString());
            this._lockAlreadyChecked = true;
        }
    }
}

