/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.migration.jcr;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.MigrationExtensionPoint;
import org.ametys.core.migration.NotMigrableInSafeModeException;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.VersionConfiguration;
import org.ametys.core.migration.version.storage.VersionStorage;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.migration.jcr.VersionsRootHelper;
import org.ametys.plugins.repository.migration.jcr.repository.VersionAmetysObject;
import org.ametys.plugins.repository.migration.jcr.repository.VersionComponentAmetysObject;
import org.ametys.plugins.repository.migration.jcr.repository.VersionsAmetysObject;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class JcrVersionStorage
extends AbstractLogEnabled
implements VersionStorage,
Serviceable,
PluginAware {
    protected AmetysObjectResolver _resolver;
    protected MigrationExtensionPoint _migrationEP;
    protected VersionsRootHelper _versionsRootHelper;
    private String _id;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
        this._migrationEP = (MigrationExtensionPoint)manager.lookup(MigrationExtensionPoint.ROLE);
        this._versionsRootHelper = (VersionsRootHelper)manager.lookup(VersionsRootHelper.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public List<Version> getVersions(String componentId, VersionConfiguration configuration, MigrationEngine.MigrationComponent component) throws MigrationException {
        if (!this._versionsRootHelper.hasRootObject()) {
            throw new MigrationException("Your existing repository does not support automatic migrations (ametys:versions does not exist). Please follow the migration guide.");
        }
        StringExpression expression = new StringExpression("componentId", Expression.Operator.EQ, componentId);
        String query = QueryHelper.getXPathQuery(null, "ametys:version", expression);
        return this._resolver.query(query).stream().map(ao -> new Version(component, componentId, (VersionStorage)this, configuration, ao.getVersionNumber(), ao.getExecutionDate().toInstant(), ao.getComment())).toList();
    }

    public VersionConfiguration createVersionConfiguration(Configuration versionConfiguration) throws ConfigurationException, NotMigrableInSafeModeException {
        return null;
    }

    public void storeVersion(Version version) throws MigrationException {
        VersionComponentAmetysObject component = this._getComponentObject(version.getComponentId(), true);
        try {
            VersionAmetysObject versionAO = (VersionAmetysObject)component.createChild("v-" + version.getVersionNumber(), "ametys:version");
            versionAO.setComponentId(version.getComponentId());
            versionAO.setVersionNumber(version.getVersionNumber());
            versionAO.setExecutionDate(DateUtils.asCalendar((ZonedDateTime)ZonedDateTime.ofInstant(version.getExecutionInstant(), ZoneId.of("UTC"))));
            versionAO.setComment(version.getComment());
            component.saveChanges();
        }
        catch (RepositoryIntegrityViolationException e) {
            throw new MigrationException("JCR data version is instable for: " + version.toString(), (Throwable)e);
        }
    }

    public Version createVersion(String componentId, MigrationEngine.MigrationComponent component, VersionConfiguration storageConfiguration, Map<String, Object> additionalValues) throws MigrationException {
        Version version = super.createVersion(componentId, component, storageConfiguration, additionalValues);
        if (!this._versionsRootHelper.hasKnownPlugins()) {
            this.getLogger().debug("End create version for component id: " + componentId + ", case 'new repository'");
            return version;
        }
        String componentPluginName = component.pluginName();
        if (!this._versionsRootHelper.isAKnownPlugin(componentPluginName)) {
            this.getLogger().debug("End create version for component id: " + componentId + ", case 'new plugin'");
            return version;
        }
        if (component.initialization() == null) {
            version.setVersionNumber("0");
        }
        this.getLogger().debug("End create version for component id: " + componentId + ", case 'already versionned, but without version stored'");
        return version;
    }

    public void removeVersion(String componentId, String versionNumber, VersionConfiguration configuration) throws MigrationException {
        String nodeName;
        VersionComponentAmetysObject component = this._getComponentObject(componentId, false);
        if (component != null && component.hasChild(nodeName = "v-" + versionNumber)) {
            VersionAmetysObject versionAO = (VersionAmetysObject)component.getChild(nodeName);
            versionAO.remove();
            component.saveChanges();
        }
    }

    public void removeAllVersions(String componentIdentifier, VersionConfiguration configuration) throws MigrationException {
        this.getLogger().debug("Start remove all version for component: {}", (Object)componentIdentifier);
        VersionComponentAmetysObject component = this._getComponentObject(componentIdentifier, false);
        if (component != null) {
            VersionsAmetysObject parent = (VersionsAmetysObject)component.getParent();
            component.remove();
            parent.saveChanges();
        }
    }

    private VersionComponentAmetysObject _getComponentObject(String componentId, boolean create) {
        this.getLogger().debug("Start _getComponentObject for component: {}", (Object)componentId);
        StringExpression expression = new StringExpression("componentId", Expression.Operator.EQ, componentId);
        String query = QueryHelper.getXPathQuery(null, "ametys:versionComponent", expression);
        AmetysObjectIterable versionsAO = this._resolver.query(query);
        this.getLogger().debug("End _getComponentObject for component: {}", (Object)componentId);
        return versionsAO.stream().findFirst().orElseGet(() -> create ? this._createComponentObject(componentId) : null);
    }

    private VersionComponentAmetysObject _createComponentObject(String componentId) {
        String componentName;
        this.getLogger().debug("Start _createComponentObject for component: {}", (Object)componentId);
        VersionsAmetysObject versions = this._versionsRootHelper.getRootObject();
        String childName = componentName = "c-" + componentId.toLowerCase().replaceAll("[^a-z0-9]", " ").trim().replaceAll("[ ]{2,}", " ").replace(" ", "-");
        int errorCount = 0;
        while (versions.hasChild(childName)) {
            childName = componentName + ++errorCount;
        }
        VersionComponentAmetysObject versionComponent = (VersionComponentAmetysObject)versions.createChild(childName, "ametys:versionComponent");
        versionComponent.setComponentId(componentId);
        versions.saveChanges();
        this.getLogger().debug("End _createComponentObject for component: {}", (Object)componentId);
        return versionComponent;
    }
}

