/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.migration.jcr;

import java.util.HashSet;
import java.util.Set;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.migration.jcr.repository.VersionsAmetysObject;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class VersionsRootHelper
implements Component,
Serviceable {
    public static final String ROLE = VersionsRootHelper.class.getName();
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
    }

    public boolean hasRootObject() throws AmetysRepositoryException {
        try {
            this._resolver.resolveByPath("/ametys:versions");
            return true;
        }
        catch (UnknownAmetysObjectException e) {
            return false;
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the versions root node", e);
        }
    }

    public VersionsAmetysObject getRootObject() throws AmetysRepositoryException {
        try {
            ModifiableTraversableAmetysObject rootNode = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath("/");
            if (rootNode.hasChild("ametys:versions")) {
                return (VersionsAmetysObject)rootNode.getChild("ametys:versions");
            }
            VersionsAmetysObject versionsNode = (VersionsAmetysObject)rootNode.createChild("ametys:versions", "ametys:versions");
            rootNode.saveChanges();
            return versionsNode;
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the versions root node", e);
        }
    }

    public boolean hasKnownPlugins() {
        return !this.getRootObject().getKnownPlugins().isEmpty();
    }

    public boolean isAKnownPlugin(String plugin) {
        return this.getRootObject().getKnownPlugins().contains(plugin);
    }

    public void updateKnownPlugins() {
        Set plugins = PluginsManager.getInstance().getPluginNames();
        VersionsAmetysObject root = this.getRootObject();
        Set<String> knownPlugins = root.getKnownPlugins();
        HashSet<String> fullList = new HashSet<String>();
        fullList.addAll(knownPlugins);
        fullList.addAll(plugins);
        root.setKnownPlugins(fullList);
        root.saveChanges();
    }
}

