/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.model;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.data.ametysobject.DataAwareAmetysObject;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.type.DataContext;

public class RepositoryDataContext
extends DataContext {
    private Optional<? extends DataAwareAmetysObject> _object = Optional.empty();
    private Optional<? extends DataAwareAmetysObject> _rootObject = Optional.empty();
    private Set<String> _externalizableData = new HashSet<String>();
    private boolean _copyExternalMetadata;

    protected RepositoryDataContext() {
    }

    protected RepositoryDataContext(DataContext context) {
        super(context);
        if (context instanceof RepositoryDataContext) {
            RepositoryDataContext repositoryContext = (RepositoryDataContext)context;
            this.withObject(repositoryContext.getObject().orElse(null));
            this._withRootObject(repositoryContext._getRootObject().orElse(null));
            this.withExternalizableData(repositoryContext.getExternalizableData());
            this.withExternalMetadataInCopy(repositoryContext.copyExternalMetadata());
        }
    }

    public static RepositoryDataContext newInstance() {
        return new RepositoryDataContext();
    }

    public static RepositoryDataContext newInstance(DataContext context) {
        return new RepositoryDataContext(context);
    }

    public RepositoryDataContext cloneContext() {
        return RepositoryDataContext.newInstance(this);
    }

    public <T extends DataAwareAmetysObject> Optional<T> getObject() {
        return this._object;
    }

    public Optional<String> getObjectId() {
        return this._object.map(AmetysObject::getId);
    }

    public <T extends RepositoryDataContext> T withObject(DataAwareAmetysObject object) {
        this._object = Optional.ofNullable(object);
        if (this._rootObject.isEmpty()) {
            this._withRootObject(object);
        }
        return (T)((Object)this);
    }

    protected <T extends DataAwareAmetysObject> Optional<T> _getRootObject() {
        return this._rootObject;
    }

    public Optional<String> getRootObjectId() {
        return this._rootObject.map(AmetysObject::getId);
    }

    protected <T extends RepositoryDataContext> T _withRootObject(DataAwareAmetysObject rootObject) {
        this._rootObject = Optional.ofNullable(rootObject);
        return (T)((Object)this);
    }

    public Set<String> getExternalizableData() {
        return this._externalizableData;
    }

    public boolean isDataExternalizable() {
        String dataPath = this.getDataPath();
        String definitionPath = ModelHelper.getDefinitionPathFromDataPath((String)dataPath);
        return this._externalizableData.contains(definitionPath);
    }

    public <T extends RepositoryDataContext> T withExternalizableData(Set<String> externalizableData) {
        this._externalizableData = externalizableData;
        return (T)((Object)this);
    }

    public boolean copyExternalMetadata() {
        return this._copyExternalMetadata;
    }

    public <T extends RepositoryDataContext> T withExternalMetadataInCopy(boolean copyExternalMetadata) {
        this._copyExternalMetadata = copyExternalMetadata;
        return (T)((Object)this);
    }
}

