/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemGroup;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.parameter.ValidationResults;

public final class ViewHelper {
    private ViewHelper() {
    }

    public static void visitView(ViewItemAccessor viewItemAccessor, BiConsumer<ViewElement, ElementDefinition> elementConsumer, BiConsumer<ModelViewItemGroup, CompositeDefinition> compositeConsumer, BiConsumer<ModelViewItemGroup, RepeaterDefinition> repeaterConsumer, Consumer<ViewItemGroup> groupConsumer) {
        for (ViewItem viewItem : viewItemAccessor.getViewItems()) {
            if (viewItem instanceof ViewElement) {
                ElementDefinition definition = ((ViewElement)viewItem).getDefinition();
                elementConsumer.accept((ViewElement)viewItem, definition);
                continue;
            }
            if (viewItem instanceof ModelViewItemGroup) {
                ModelItemGroup modelItemGroup = ((ModelViewItemGroup)viewItem).getDefinition();
                if (modelItemGroup instanceof CompositeDefinition) {
                    compositeConsumer.accept((ModelViewItemGroup)viewItem, (CompositeDefinition)modelItemGroup);
                    continue;
                }
                if (!(modelItemGroup instanceof RepeaterDefinition)) continue;
                repeaterConsumer.accept((ModelViewItemGroup)viewItem, (RepeaterDefinition)modelItemGroup);
                continue;
            }
            if (!(viewItem instanceof ViewItemGroup)) continue;
            groupConsumer.accept((ViewItemGroup)viewItem);
        }
    }

    public static ValidationResults validateValues(ViewItemAccessor viewItemAccessor, Optional<Map<String, Object>> values) {
        return ViewHelper._validateValues(viewItemAccessor, values, "");
    }

    private static ValidationResults _validateValues(ViewItemAccessor viewItemAccessor, Optional<Map<String, Object>> values, String prefix) {
        ValidationResults results = new ValidationResults();
        ViewHelper.visitView(viewItemAccessor, (element, definition) -> {
            String name = definition.getName();
            String dataPath = prefix + name;
            Object value = values.map(v -> v.get(name)).orElse(null);
            ValidationResult result = ModelHelper.validateValue((ElementDefinition)definition, value);
            results.addResult(dataPath, result);
        }, (group, definition) -> {
            String name = definition.getName();
            String updatedPrefix = prefix + name + "/";
            Optional<Map<String, Object>> value = values.map(v -> v.get(name)).filter(Map.class::isInstance).map(Map.class::cast);
            results.addResults(ViewHelper._validateValues((ViewItemAccessor)group, value, updatedPrefix));
        }, (group, definition) -> {
            String name = definition.getName();
            String dataPath = prefix + name;
            Optional<List<Map<String, Object>>> entries = values.map(v -> v.get(name)).filter(List.class::isInstance).map(List.class::cast);
            results.addResults(ViewHelper._validateRepeaterEntries(group, definition, entries, dataPath));
        }, group -> results.addResults(ViewHelper._validateValues((ViewItemAccessor)group, values, prefix)));
        return results;
    }

    private static ValidationResults _validateRepeaterEntries(ModelViewItemGroup viewItem, RepeaterDefinition definition, Optional<List<Map<String, Object>>> entries, String dataPath) {
        ValidationResults results = new ValidationResults();
        int repeaterSize = entries.map(List::size).orElse(0);
        List<I18nizableText> repeaterSizeErrors = ViewHelper._validateRepeaterSize(definition, repeaterSize);
        if (!repeaterSizeErrors.isEmpty()) {
            ValidationResult repeaterResult = new ValidationResult();
            repeaterResult.addErrors(repeaterSizeErrors);
            results.addResult(dataPath, repeaterResult);
        } else if (entries.isPresent()) {
            for (int i = 0; i < repeaterSize; ++i) {
                Map<String, Object> entry = entries.get().get(i);
                String prefix = dataPath + "[" + (i + 1) + "]/";
                results.addResults(ViewHelper._validateValues((ViewItemAccessor)viewItem, Optional.of(entry), prefix));
            }
        }
        return results;
    }

    private static List<I18nizableText> _validateRepeaterSize(RepeaterDefinition definition, int repeaterSize) {
        ArrayList<String> parameters;
        int minSize = definition.getMinSize();
        int maxSize = definition.getMaxSize();
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        if (repeaterSize < minSize) {
            parameters = new ArrayList<String>();
            parameters.add(definition.getName());
            parameters.add(Integer.toString(minSize));
            errors.add(new I18nizableText("plugin.cms", "CONTENT_EDITION_VALIDATION_ERRORS_REPEATER_MINSIZE", parameters));
        }
        if (maxSize > 0 && repeaterSize > maxSize) {
            parameters = new ArrayList();
            parameters.add(definition.getName());
            parameters.add(Integer.toString(maxSize));
            errors.add(new I18nizableText("plugin.cms", "CONTENT_EDITION_VALIDATION_ERRORS_REPEATER_MAXSIZE", parameters));
        }
        return errors;
    }
}

