/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.provider;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.ametys.plugins.repository.provider.WorkspaceSelector;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractRepository
extends AbstractLogEnabled
implements Repository,
Serviceable {
    public static final String ROLE = "javax.jcr.Repository";
    public static final String CONTEXT_REPOSITORY_KEY = "org.ametys.repository.Repository";
    public static final String CONTEXT_CREDENTIALS_KEY = "org.ametys.repository.Credentials";
    public static final String CONTEXT_IS_JNDI_KEY = "org.ametys.repository.JNDI";
    protected Repository _delegate;
    protected ServiceManager _manager;
    private WorkspaceSelector _workspaceSelector;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._workspaceSelector = (WorkspaceSelector)manager.lookup(WorkspaceSelector.ROLE);
    }

    public String getDescriptor(String key) {
        return this._delegate.getDescriptor(key);
    }

    public String[] getDescriptorKeys() {
        return this._delegate.getDescriptorKeys();
    }

    public Value getDescriptorValue(String key) {
        return this._delegate.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this._delegate.getDescriptorValues(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this._delegate.isSingleValueDescriptor(key);
    }

    public boolean isStandardDescriptor(String key) {
        return this._delegate.isStandardDescriptor(key);
    }

    public Session login() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        String workspace = this._workspaceSelector.getWorkspace();
        return this.login(workspace);
    }

    public Session login(Credentials creds) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        String workspace = this._workspaceSelector.getWorkspace();
        return this.login(creds, workspace);
    }

    public Session login(Credentials creds, String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        String login;
        if (creds != null && !(creds instanceof SimpleCredentials)) {
            throw new RepositoryException("Credentials must be instance of SimpleCredentials");
        }
        if (creds != null && !(login = ((SimpleCredentials)creds).getUserID()).equals("ametys")) {
            throw new LoginException("The authentication is only allowed with the ametys login.");
        }
        return this.login(workspace);
    }
}

