/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.provider;

import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.runtime.config.Config;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DerbyPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.MySqlPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.OraclePersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.PostgreSQLPersistenceManager;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;

public class AmetysPersistenceManager
extends BundleDbPersistenceManager {
    public static final String CONFIG_USE_DEFAULT = "org.ametys.plugins.repository.default-datasource";
    public static final String CONFIG_PM_DATASOURCE = "org.ametys.plugins.repository.datasource";
    private BundleDbPersistenceManager _wrappedPM;
    private boolean _useDefault = (Boolean)Config.getInstance().getValue("org.ametys.plugins.repository.default-datasource");
    private String _workspace;

    public AmetysPersistenceManager() {
        if (this._useDefault) {
            this._wrappedPM = new DerbyPersistenceManager();
            this._wrappedPM.setSchemaObjectPrefix("");
            this._wrappedPM.setExternalBLOBs(true);
        } else {
            String dbType;
            String datasource = (String)Config.getInstance().getValue(CONFIG_PM_DATASOURCE);
            AbstractDataSourceManager.DataSourceDefinition dsDefinition = ConnectionHelper.getDataSourceDefinition((String)datasource);
            Map parameters = dsDefinition.getParameters();
            String defUrl = (String)parameters.get("url");
            String defDriver = (String)parameters.get("driver");
            String defUser = (String)parameters.get("user");
            String defPassword = (String)parameters.get("password");
            switch (dbType = ConnectionHelper.getDatabaseType((String)defUrl)) {
                case "derby": {
                    this._wrappedPM = new DerbyPersistenceManager();
                    break;
                }
                case "mysql": {
                    this._wrappedPM = new MySqlPersistenceManager();
                    break;
                }
                case "oracle": {
                    this._wrappedPM = new OraclePersistenceManager();
                    break;
                }
                case "postgresql": {
                    this._wrappedPM = new PostgreSQLPersistenceManager();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Datasource URL " + defUrl + " is not supported for Jackrabbit PersistenceManagers.");
                }
            }
            this._wrappedPM.setUrl(defUrl);
            this._wrappedPM.setDriver(defDriver);
            this._wrappedPM.setUser(defUser);
            this._wrappedPM.setPassword(defPassword);
        }
    }

    public BundleDbPersistenceManager getWrappedPM() {
        return this._wrappedPM;
    }

    public void setWorkspace(String workspace) {
        this._workspace = workspace;
    }

    public void setUrl(String newUrl) {
        throw new UnsupportedOperationException("setUrl() method is not supported for AmetysPersistenceManager.");
    }

    public void setUser(String unused) {
        throw new UnsupportedOperationException("setUser() method is not supported for AmetysPersistenceManager.");
    }

    public void setPassword(String unused) {
        throw new UnsupportedOperationException("setPassword() method is not supported for AmetysPersistenceManager.");
    }

    public void setDriver(String unused) {
        throw new UnsupportedOperationException("setDriver() method is not supported for AmetysPersistenceManager.");
    }

    public void init(PMContext ctx) throws Exception {
        if (this._useDefault) {
            String dbUrl = "jdbc:derby:" + ctx.getHomeDir().getCanonicalPath() + "/db;create=true";
            this._wrappedPM.setUrl(dbUrl);
        } else {
            String prefix = this._workspace == null ? "version_" : this._workspace + "_";
            this._wrappedPM.setSchemaObjectPrefix(prefix);
        }
        this._wrappedPM.init(ctx);
    }

    public void close() throws Exception {
        this._wrappedPM.close();
    }

    public NodeState createNew(NodeId id) {
        return this._wrappedPM.createNew(id);
    }

    public PropertyState createNew(PropertyId id) {
        return this._wrappedPM.createNew(id);
    }

    public NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        return this._wrappedPM.load(id);
    }

    public PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        return this._wrappedPM.load(id);
    }

    public NodeReferences loadReferencesTo(NodeId id) throws NoSuchItemStateException, ItemStateException {
        return this._wrappedPM.loadReferencesTo(id);
    }

    public boolean exists(NodeId id) throws ItemStateException {
        return this._wrappedPM.exists(id);
    }

    public boolean exists(PropertyId id) throws ItemStateException {
        return this._wrappedPM.exists(id);
    }

    public boolean existsReferencesTo(NodeId targetId) throws ItemStateException {
        return this._wrappedPM.existsReferencesTo(targetId);
    }

    public void store(ChangeLog changeLog) throws ItemStateException {
        this._wrappedPM.store(changeLog);
    }

    public ConsistencyReport check(String[] uuids, boolean recursive, boolean fix, String lostNFoundId, ConsistencyCheckListener listener) throws RepositoryException {
        return this._wrappedPM.check(uuids, recursive, fix, lostNFoundId, listener);
    }

    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
        this._wrappedPM.checkConsistency(uuids, recursive, fix);
    }

    public synchronized List<NodeId> getAllNodeIds(NodeId bigger, int maxCount) throws ItemStateException, RepositoryException {
        return this._wrappedPM.getAllNodeIds(bigger, maxCount);
    }

    public synchronized void destroy(NodeReferences refs) throws ItemStateException {
        this._wrappedPM.destroy(refs);
    }

    public synchronized Map<NodeId, NodeInfo> getAllNodeInfos(NodeId bigger, int maxCount) throws ItemStateException {
        return this._wrappedPM.getAllNodeInfos(bigger, maxCount);
    }

    public void setBlockOnConnectionLoss(String block) {
        this._wrappedPM.setBlockOnConnectionLoss(block);
    }

    public void setBundleCacheSize(String bundleCacheSize) {
        this._wrappedPM.setBundleCacheSize(bundleCacheSize);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this._wrappedPM.setConnectionFactory(connectionFactory);
    }

    public void setConsistencyCheck(String check) {
        this._wrappedPM.setConsistencyCheck(check);
    }

    public void setConsistencyFix(String fix) {
        this._wrappedPM.setConsistencyFix(fix);
    }

    public void setErrorHandling(String errHandling) {
        this._wrappedPM.setErrorHandling(errHandling);
    }

    public void setEventChannel(UpdateEventChannel eventChannel) {
        this._wrappedPM.setEventChannel(eventChannel);
    }

    public void setExternalBLOBs(boolean externalBlobs) {
        this._wrappedPM.setExternalBLOBs(externalBlobs);
    }

    public void setMinBlobSize(String minBlobSize) {
        this._wrappedPM.setMinBlobSize(minBlobSize);
    }

    public void setSchemaObjectPrefix(String schemaPrefix) {
        this._wrappedPM.setSchemaObjectPrefix(schemaPrefix);
    }

    public String toString() {
        return this._wrappedPM.toString();
    }
}

