/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.provider;

import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.ametys.plugins.repository.provider.AmetysSession;
import org.ametys.plugins.repository.provider.LogoutManager;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.security.authentication.AuthContext;

public class AmetysRepository
extends RepositoryImpl {
    private LogoutManager _logoutManager;
    private AtomicInteger _sessionCount = new AtomicInteger();
    private boolean _isShuttingDown;

    public AmetysRepository(RepositoryConfig config) throws RepositoryException {
        super(config);
    }

    public RepositoryContext getContext() {
        return this.context;
    }

    public RepositoryStatistics getRepositoryStatistics() {
        return this.context.getRepositoryStatistics();
    }

    protected SessionImpl createSessionInstance(AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new AmetysSession(this.context, loginContext, wspConfig);
    }

    protected SessionImpl createSessionInstance(Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new AmetysSession(this.context, subject, wspConfig);
    }

    void setLogoutManager(LogoutManager logoutManager) {
        this._logoutManager = logoutManager;
    }

    LogoutManager getLogoutManager() {
        return this._logoutManager;
    }

    int getSessionCount() {
        return this._sessionCount.get();
    }

    protected void onSessionCreated(SessionImpl session) {
        super.onSessionCreated(session);
        if (session instanceof AmetysSession) {
            this._sessionCount.incrementAndGet();
        }
    }

    public void loggedOut(SessionImpl session) {
        super.loggedOut(session);
        if (session instanceof AmetysSession) {
            this._sessionCount.decrementAndGet();
        }
    }

    protected synchronized void doShutdown() {
        this._isShuttingDown = true;
        super.doShutdown();
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (this._isShuttingDown) {
            throw new RepositoryException("Cannot login as the repository is shutting down.");
        }
        return super.login(credentials, workspaceName);
    }
}

