/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.provider;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ametys.plugins.repository.provider.AbstractRepository;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.environment.Context;

public class JNDIRepository
extends AbstractRepository
implements Initializable,
Contextualizable,
Component {
    private Context _context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void initialize() throws Exception {
        String name = (String)Config.getInstance().getValue("org.ametys.plugins.repository.jndi");
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this._delegate = (Repository)ctx.lookup(name);
            this._context.setAttribute("org.ametys.repository.Repository", (Object)this._delegate);
            this._context.setAttribute("org.ametys.repository.Credentials", (Object)new SimpleCredentials("ametys", new char[0]));
            this._context.setAttribute("org.ametys.repository.JNDI", (Object)true);
        }
        catch (NamingException e) {
            throw new ConfigurationException("Cannot lookup JNDI entry '" + name + "'", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    public Session login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this._delegate.login((Credentials)new SimpleCredentials("ametys", new char[0]), workspace);
    }
}

