/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.plugins.repository.provider.AbstractRepository;
import org.ametys.plugins.repository.provider.AmetysRepository;
import org.ametys.plugins.repository.provider.AmetysSession;
import org.ametys.plugins.repository.provider.LogoutManager;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.MoveableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.core.cache.CacheManager;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public class JackrabbitRepository
extends AbstractRepository
implements LogoutManager,
Initializable,
Contextualizable,
Disposable,
Component {
    private static final String __REPOSITORY_NODETYPES_PATH = "ametys-home://data/repository/repository/nodetypes";
    private org.apache.avalon.framework.context.Context _avalonContext;
    private Context _context;
    private Session _adminSession;
    private SourceResolver _resolver;
    private Source _customNodeTypesBackupSource;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._avalonContext = context;
        this._context = (Context)context.get((Object)"environment-context");
    }

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        smanager.lookup(ConnectionHelper.ROLE);
        this._resolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public void initialize() throws Exception {
        this._backupCustomNodetypes();
        RepositoryConfig repositoryConfig = this.createRepositoryConfig();
        AmetysRepository repo = new AmetysRepository(repositoryConfig);
        this._delegate = repo;
        ((AmetysRepository)this._delegate).setLogoutManager(this);
        Long cacheSize = (Long)Config.getInstance().getValue("org.ametys.plugins.repository.cache");
        if (cacheSize == null || cacheSize <= 0L) {
            cacheSize = 0x1000000L;
        }
        CacheManager cacheManager = repo.getCacheManager();
        cacheManager.setMaxMemory(cacheSize.longValue());
        cacheManager.setMaxMemoryPerCache(cacheSize / 4L);
        cacheManager.setMinMemoryPerCache(cacheSize / 128L);
        this._context.setAttribute("org.ametys.repository.Repository", (Object)this._delegate);
        this._context.setAttribute("org.ametys.repository.Credentials", (Object)new SimpleCredentials("ametys", new char[0]));
        this._context.setAttribute("org.ametys.repository.JNDI", (Object)false);
        this._adminSession = this.login("default");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JCR Repository running");
        }
    }

    public void dispose() {
        AmetysRepository repo = (AmetysRepository)this._delegate;
        repo.setLogoutManager(null);
        repo.shutdown();
    }

    public RepositoryStatistics getRepositoryStatistics() {
        AmetysRepository repo = (AmetysRepository)this._delegate;
        return repo.getRepositoryStatistics();
    }

    public Session getAdminSession() throws RepositoryException {
        this._adminSession.refresh(false);
        return this._adminSession;
    }

    public String[] getWorkspaces() throws RepositoryException {
        return this._adminSession.getWorkspace().getAccessibleWorkspaceNames();
    }

    RepositoryConfig createRepositoryConfig() throws ConfigurationException {
        String config = this._context.getRealPath("/WEB-INF/param/repository.xml");
        File homeFile = new File(AmetysHomeHelper.getAmetysHomeData(), "repository");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating JCR Repository config at: " + homeFile.getAbsolutePath());
        }
        return RepositoryConfig.create((String)config, (String)homeFile.getAbsolutePath());
    }

    int getSessionCount() {
        return ((AmetysRepository)this._delegate).getSessionCount();
    }

    public Session login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Getting JCR Session");
            }
            try {
                Session session;
                Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._avalonContext);
                HashMap<String, Session> sessions = (HashMap<String, Session>)request.getAttribute("jcr-sessions");
                if (sessions == null) {
                    sessions = new HashMap<String, Session>();
                    request.setAttribute("jcr-sessions", sessions);
                }
                if ((session = (Session)sessions.get(workspace)) == null || !session.isLive()) {
                    session = this._delegate.login((Credentials)new SimpleCredentials("ametys", new char[0]), workspace);
                    sessions.put(workspace, session);
                }
                return session;
            }
            catch (CascadingRuntimeException e) {
                if (e.getCause() instanceof ContextException) {
                    Session session = this._delegate.login((Credentials)new SimpleCredentials("ametys", new char[0]), workspace);
                    return session;
                }
                throw e;
            }
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get Session", e);
        }
    }

    @Override
    public void logout(Session session) {
        if (!(session instanceof AmetysSession)) {
            throw new IllegalArgumentException("JCR Session should be an instance of AmetysSession");
        }
        AmetysSession ametysSession = (AmetysSession)session;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Logging out AmetysSession");
        }
        try {
            ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._avalonContext);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("AmetysSession logout delayed until the end of the HTTP request.");
            }
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Not in a request. AmetysSession will be actually logged out.");
            }
            ametysSession.forceLogout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _backupCustomNodetypes() {
        Source source = null;
        Source destination = null;
        try {
            source = this._resolver.resolveURI("ametys-home://data/repository/repository/nodetypes/custom_nodetypes.xml");
            if (source.exists() && source instanceof ModifiableSource) {
                ModifiableSource fsource = (ModifiableSource)source;
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").withZone(ZoneId.systemDefault());
                String timestamp = formatter.format(Instant.now());
                destination = this._resolver.resolveURI("ametys-home://data/repository/repository/nodetypes/custom_nodetypes-" + timestamp + ".xml");
                if (destination.exists()) {
                    fsource.delete();
                    this.getLogger().warn("Impossible to backup custom_nodetypes.xml, custom_nodetypes-" + timestamp + ".xml already exists.");
                } else {
                    this._customNodeTypesBackupSource = destination;
                    this.getLogger().info("Backup custom_nodetypes.xml as custom_nodetypes-" + timestamp + ".xml");
                    ((MoveableSource)fsource).moveTo(destination);
                }
                if (fsource.exists()) {
                    this.getLogger().error("Impossible to delete custom_nodetypes.xml after creating a backup.");
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("An error occurred while backuping the custom_nodetypes.xml file", (Throwable)e);
        }
        finally {
            this._resolver.release(source);
            this._resolver.release(destination);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void compareCustomNodetypes() {
        if (this._customNodeTypesBackupSource != null && this._customNodeTypesBackupSource.exists()) {
            source = null;
            try {
                source = this._resolver.resolveURI("ametys-home://data/repository/repository/nodetypes/custom_nodetypes.xml");
                if (source.exists() && source instanceof ModifiableTraversableSource) {
                    if (this._compareSources((TraversableSource)source, (TraversableSource)this._customNodeTypesBackupSource)) {
                        this.getLogger().info(((TraversableSource)this._customNodeTypesBackupSource).getName() + " will be deleted, no changes found.");
                        ((ModifiableTraversableSource)this._customNodeTypesBackupSource).delete();
                        if (!this._customNodeTypesBackupSource.exists()) ** GOTO lbl23
                        this.getLogger().error("Impossible to delete custom_nodetypes.xml after creating a backup.");
                    }
                    this.getLogger().info(((TraversableSource)this._customNodeTypesBackupSource).getName() + " will be kept, changes found with last version.");
                }
                this.getLogger().warn("Impossible to compare custom_nodetypes.xml, it seems to be unavailable.");
            }
            catch (IOException e) {
                this.getLogger().error("Impossible to compare custom_nodetypes.xml with it's backup '" + this._customNodeTypesBackupSource.getURI() + "'", (Throwable)e);
            }
            finally {
                this._resolver.release(source);
            }
        } else {
            this.getLogger().debug("There is no backup of custom_nodetypes.xml to compare");
        }
lbl23:
        // 6 sources

        this._resolver.release(this._customNodeTypesBackupSource);
        this._customNodeTypesBackupSource = null;
    }

    protected boolean _compareSources(TraversableSource source1, TraversableSource source2) throws IOException {
        if (source1 == null && source2 == null) {
            return true;
        }
        if (source1 == null || source2 == null) {
            return false;
        }
        boolean source1Exists = source1.exists();
        if (source1Exists != source2.exists()) {
            return false;
        }
        if (!source1Exists) {
            return true;
        }
        if (source1.isCollection() || source2.isCollection()) {
            throw new IOException("Can't compare collections, only content source");
        }
        if (source1.getContentLength() != source2.getContentLength()) {
            return false;
        }
        if (source1.getURI().equals(source2.getURI())) {
            return true;
        }
        try (InputStream input1 = source1.getInputStream();){
            boolean bl;
            block19: {
                InputStream input2 = source2.getInputStream();
                try {
                    bl = IOUtils.contentEquals((InputStream)input1, (InputStream)input2);
                    if (input2 == null) break block19;
                }
                catch (Throwable throwable) {
                    if (input2 != null) {
                        try {
                            input2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input2.close();
            }
            return bl;
        }
    }
}

