/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SortCriteria {
    private List<SortCriterion> _criteria = new ArrayList<SortCriterion>();

    public void addCriterion(String metadataPath, boolean ascending, boolean normalize) {
        this._criteria.add(new SortCriterion(this, metadataPath, null, ascending, normalize));
    }

    public void addJCRPropertyCriterion(String jcrProperty, boolean ascending, boolean normalize) {
        this._criteria.add(new SortCriterion(this, null, jcrProperty, ascending, normalize));
    }

    public List<SortCriterion> getCriteria() {
        return Collections.unmodifiableList(this._criteria);
    }

    public String build() {
        if (this._criteria.isEmpty()) {
            return "";
        }
        StringBuffer exp = new StringBuffer("order by ");
        for (int i = 0; i < this._criteria.size(); ++i) {
            if (i != 0) {
                exp.append(", ");
            }
            SortCriterion criterion = this._criteria.get(i);
            exp.append(criterion.build());
        }
        return exp.toString();
    }

    public class SortCriterion {
        protected String _metadataPath;
        protected String _jcrProperty;
        protected boolean _ascending;
        protected boolean _normalize;

        public SortCriterion(SortCriteria this$0, String metadataPath, String jcrProperty, boolean ascending, boolean normalize) {
            this._metadataPath = metadataPath;
            this._jcrProperty = jcrProperty;
            this._ascending = ascending;
            this._normalize = normalize;
        }

        public String getMetadataPath() {
            return this._metadataPath;
        }

        public void setMetadataPath(String metadataPath) {
            this._metadataPath = metadataPath;
        }

        public String getJcrProperty() {
            return this._jcrProperty;
        }

        public void setJcrProperty(String jcrProperty) {
            this._jcrProperty = jcrProperty;
        }

        public boolean isAscending() {
            return this._ascending;
        }

        public void setAscending(boolean ascending) {
            this._ascending = ascending;
        }

        public boolean isNormalizedSort() {
            return this._normalize;
        }

        public void setNormalize(boolean normalize) {
            this._normalize = normalize;
        }

        public String build() {
            String ascending;
            StringBuilder buff = new StringBuilder();
            String string = ascending = this._ascending ? "ascending" : "descending";
            if (this._metadataPath != null) {
                Object metadata = "";
                String[] path = this._metadataPath.split("/");
                for (int j = 0; j < path.length; ++j) {
                    metadata = j == path.length - 1 ? (String)metadata + "@ametys:" + path[j] : (String)metadata + "ametys:" + path[j] + "/";
                }
                if (this._normalize) {
                    buff.append("rep:normalize(" + (String)metadata + ") " + ascending);
                } else {
                    buff.append((String)metadata + " " + ascending);
                }
            } else if (this._normalize) {
                buff.append("rep:normalize(@" + this._jcrProperty + ") " + ascending);
            } else {
                buff.append("@" + this._jcrProperty + " " + ascending);
            }
            return buff.toString();
        }
    }
}

