/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.query.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.plugins.repository.query.expression.Expression;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLogicalExpression
extends ArrayList<Expression>
implements Expression {
    public AbstractLogicalExpression(Collection<Expression> exprs) {
        super(exprs);
    }

    public AbstractLogicalExpression(Expression ... exprs) {
        super(Arrays.asList(exprs));
    }

    @Override
    public String build() {
        String logicalOperator = this.getLogicalOperator().toString();
        Object joinExpression = this.stream().filter(Objects::nonNull).map(Expression::build).filter(StringUtils::isNotBlank).collect(Collectors.joining(logicalOperator));
        if (((String)joinExpression).contains(logicalOperator)) {
            joinExpression = "(" + (String)joinExpression + ")";
        }
        return joinExpression;
    }

    protected abstract Expression.LogicalOperator getLogicalOperator();
}

