/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.query.expression;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Date;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateExpression
implements Expression {
    private Date _value;
    private MetadataExpression _metadata;
    private Expression.Operator _operator;

    public DateExpression(String metadata, Expression.Operator operator, Date value) {
        this._value = value;
        this._operator = operator;
        this._metadata = new MetadataExpression(metadata);
    }

    public DateExpression(String metadata, Expression.Operator operator, Date value, ExpressionContext context) {
        this._value = value;
        this._operator = operator;
        this._metadata = new MetadataExpression(metadata, context);
    }

    public DateExpression(String metadata, Expression.Operator operator, LocalDate value) {
        this(metadata, operator, DateUtils.asDate((LocalDate)value));
    }

    public DateExpression(String metadata, Expression.Operator operator, LocalDate value, ExpressionContext context) {
        this(metadata, operator, DateUtils.asDate((LocalDate)value), context);
    }

    public DateExpression(String metadata, Expression.Operator operator, ZonedDateTime value) {
        this(metadata, operator, DateUtils.asDate((ZonedDateTime)value));
    }

    public DateExpression(String metadata, Expression.Operator operator, ZonedDateTime value, ExpressionContext context) {
        this(metadata, operator, DateUtils.asDate((ZonedDateTime)value), context);
    }

    @Override
    public String build() {
        return this._metadata.build() + " " + String.valueOf((Object)this._operator) + " xs:dateTime('" + FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ").format(this._value) + "')";
    }
}

