/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.query.expression;

import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;

public class MetadataExpression
implements Expression {
    private String _metadata;
    private String _path;
    private ExpressionContext _context;

    public MetadataExpression(String metadata) {
        this(metadata, ExpressionContext.newInstance());
    }

    public MetadataExpression(String metadata, ExpressionContext context) {
        int index = metadata.lastIndexOf(47);
        boolean isComposite = index != -1;
        this._path = isComposite ? metadata.substring(0, index) : null;
        this._metadata = isComposite ? metadata.substring(index + 1) : metadata;
        this._context = context;
    }

    @Override
    public String build() {
        String repositoryPrefix;
        StringBuilder buff = new StringBuilder();
        String string = repositoryPrefix = this._context.internal() ? "ametys-internal" : "ametys";
        if (this._context.unversioned()) {
            buff.append("ametys-internal").append(":unversioned/");
        }
        if (this._path != null) {
            String[] parts;
            for (String part : parts = this._path.split("/")) {
                if ("*".equals(part)) {
                    buff.append(part).append('/');
                    continue;
                }
                buff.append(repositoryPrefix).append(':').append(part).append('/');
            }
        }
        buff.append('@').append(repositoryPrefix).append(':').append(this._metadata);
        return buff.toString();
    }
}

