/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.query.expression;

import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.MetadataExpression;

public class MultilingualStringExpression
implements Expression {
    private String _value;
    private MetadataExpression _metadata;
    private Expression.Operator _operator;
    private boolean _caseInsensitive;
    private String _lang;

    public MultilingualStringExpression(String metadata, Expression.Operator operator, String value, String lang) {
        this._value = value;
        this._operator = operator;
        this._metadata = new MetadataExpression(metadata);
        this._caseInsensitive = false;
        this._lang = lang;
    }

    public MultilingualStringExpression(String metadata, Expression.Operator operator, String value, String lang, ExpressionContext context) {
        this._value = value;
        this._operator = operator;
        this._metadata = new MetadataExpression(metadata, context);
        this._caseInsensitive = context.caseInsensitive();
        this._lang = lang;
    }

    @Override
    public String build() {
        if (this._operator.equals((Object)Expression.Operator.WD)) {
            if (this._caseInsensitive) {
                return "jcr:like(fn:lower-case(" + this._multilingualPath() + "), '%" + this._escapeValue(this._value.toLowerCase()) + "%')";
            }
            return "jcr:like(" + this._multilingualPath() + ", '%" + this._escapeValue(this._value) + "%')";
        }
        if (this._caseInsensitive) {
            return "fn:lower-case(" + this._multilingualPath() + ") " + String.valueOf((Object)this._operator) + " '" + this._value.toLowerCase().replaceAll("'", "''") + "'";
        }
        return this._multilingualPath() + " " + String.valueOf((Object)this._operator) + " '" + this._value.replaceAll("'", "''") + "'";
    }

    private String _escapeValue(String value) {
        return value.replaceAll("(['\\-_\"\\\\%])", "\\\\$1").replaceAll("'", "''");
    }

    private String _multilingualPath() {
        return this._metadata.build() + "/ametys:" + this._lang;
    }
}

