/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.query.expression;

import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.MetadataExpression;

public class StringExpression
implements Expression {
    private String _value;
    private MetadataExpression _metadata;
    private Expression.Operator _operator;
    private boolean _caseInsensitive;

    public StringExpression(String metadata, Expression.Operator operator, String value) {
        this._value = value;
        this._operator = operator;
        this._metadata = new MetadataExpression(metadata);
        this._caseInsensitive = false;
    }

    public StringExpression(String metadata, Expression.Operator operator, String value, ExpressionContext context) {
        this._value = value;
        this._operator = operator;
        this._metadata = new MetadataExpression(metadata, context);
        this._caseInsensitive = context.caseInsensitive();
    }

    @Override
    public String build() {
        if (this._operator.equals((Object)Expression.Operator.WD)) {
            if (this._caseInsensitive) {
                return "jcr:like(fn:lower-case(" + this._metadata.build() + "), '%" + this._escapeValue(this._value.toLowerCase()) + "%')";
            }
            return "jcr:like(" + this._metadata.build() + ", '%" + this._escapeValue(this._value) + "%')";
        }
        if (this._caseInsensitive) {
            return "fn:lower-case(" + this._metadata.build() + ") " + String.valueOf((Object)this._operator) + " '" + this._value.toLowerCase().replaceAll("'", "''") + "'";
        }
        return this._metadata.build() + " " + String.valueOf((Object)this._operator) + " '" + this._value.replaceAll("'", "''") + "'";
    }

    private String _escapeValue(String value) {
        return value.replaceAll("(['\\-_\"\\\\%])", "\\\\$1").replaceAll("'", "''");
    }
}

