/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.query.expression;

import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;

public class UserExpression
implements Expression {
    private UserIdentity _user;
    private Expression.Operator _operator;
    private String _metadata;
    private boolean _unversioned;
    private boolean _multiple;

    public UserExpression(String metadata, Expression.Operator operator, String value) {
        this(metadata, operator, UserIdentity.stringToUserIdentity((String)value), false);
    }

    public UserExpression(String metadata, Expression.Operator operator, String value, boolean multiple) {
        this(metadata, operator, UserIdentity.stringToUserIdentity((String)value), multiple, false);
    }

    public UserExpression(String metadata, Expression.Operator operator, String value, boolean multiple, boolean unversioned) {
        this(metadata, operator, UserIdentity.stringToUserIdentity((String)value), multiple, unversioned);
    }

    public UserExpression(String metadata, Expression.Operator operator, UserIdentity userIdentity) {
        this(metadata, operator, userIdentity, false, false);
    }

    public UserExpression(String metadata, Expression.Operator operator, UserIdentity userIdentity, boolean multiple) {
        this(metadata, operator, userIdentity, multiple, false);
    }

    public UserExpression(String metadata, Expression.Operator operator, UserIdentity userIdentity, boolean multiple, boolean unversioned) {
        this._user = userIdentity;
        this._metadata = metadata;
        this._unversioned = unversioned;
        this._operator = operator;
        this._multiple = multiple;
    }

    @Override
    public String build() {
        AndExpression expr = new AndExpression(new UserLoginExpression(this, this._metadata, this._operator, this._user.getLogin(), this._multiple, this._unversioned), new UserPopulationExpression(this, this._metadata, this._operator, this._user.getPopulationId(), this._multiple, this._unversioned));
        return expr.build();
    }

    class UserLoginExpression
    implements Expression {
        private String _uleValue;
        private Expression.Operator _uleOperator;
        private String _uleMetadata;
        private String _ulePath;
        private boolean _uleUnversioned;
        private boolean _uleMultiple;

        public UserLoginExpression(UserExpression this$0, String metadata, Expression.Operator operator, String value, boolean multiple, boolean unversioned) {
            this._uleValue = value;
            this._uleOperator = operator;
            int index = metadata.lastIndexOf(47);
            boolean isComposite = index != -1;
            this._ulePath = isComposite ? metadata.substring(0, index) : null;
            this._uleMetadata = isComposite ? metadata.substring(index + 1) : metadata;
            this._uleUnversioned = unversioned;
            this._uleMultiple = multiple;
        }

        @Override
        public String build() {
            StringBuilder buff = new StringBuilder();
            if (this._uleUnversioned) {
                buff.append("ametys-internal").append(":unversioned/");
            }
            if (this._ulePath != null) {
                String[] parts;
                for (String part : parts = this._ulePath.split("/")) {
                    if ("*".equals(part)) {
                        buff.append(part).append('/');
                        continue;
                    }
                    buff.append("ametys").append(':').append(part).append('/');
                }
            }
            buff.append("ametys").append(':').append(this._uleMetadata).append('/');
            if (this._uleMultiple) {
                buff.append("*/");
            }
            buff.append('@').append("ametys").append(':').append("login");
            buff.append(" " + String.valueOf((Object)this._uleOperator));
            buff.append(" '" + this._uleValue.replaceAll("'", "''") + "'");
            return buff.toString();
        }
    }

    class UserPopulationExpression
    implements Expression {
        private String _upeValue;
        private Expression.Operator _upeOperator;
        private String _upeMetadata;
        private String _upePath;
        private boolean _upeUnversioned;
        private boolean _upeMultiple;

        public UserPopulationExpression(UserExpression this$0, String metadata, Expression.Operator operator, String value, boolean multiple, boolean unversioned) {
            this._upeValue = value;
            this._upeOperator = operator;
            int index = metadata.lastIndexOf(47);
            boolean isComposite = index != -1;
            this._upePath = isComposite ? metadata.substring(0, index) : null;
            this._upeMetadata = isComposite ? metadata.substring(index + 1) : metadata;
            this._upeUnversioned = unversioned;
            this._upeMultiple = multiple;
        }

        @Override
        public String build() {
            StringBuilder buff = new StringBuilder();
            if (this._upeUnversioned) {
                buff.append("ametys-internal").append(":unversioned/");
            }
            if (this._upePath != null) {
                String[] parts;
                for (String part : parts = this._upePath.split("/")) {
                    if ("*".equals(part)) {
                        buff.append(part).append('/');
                        continue;
                    }
                    buff.append("ametys").append(':').append(part).append('/');
                }
            }
            buff.append("ametys").append(':').append(this._upeMetadata).append('/');
            if (this._upeMultiple) {
                buff.append("*/");
            }
            buff.append('@').append("ametys").append(':').append("population");
            buff.append(" " + String.valueOf((Object)this._upeOperator));
            buff.append(" '" + this._upeValue + "'");
            return buff.toString();
        }
    }
}

