/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.script;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.ametys.plugins.core.ui.script.ScriptExecArguments;
import org.ametys.plugins.core.ui.script.StaticConfigurableScriptBinding;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class RepositoryScriptBinding
extends StaticConfigurableScriptBinding {
    private RepositoryProvider _repositoryProvider;
    private AmetysObjectResolver _ametysResolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._repositoryProvider = (RepositoryProvider)serviceManager.lookup(RepositoryProvider.ROLE);
        this._ametysResolver = (AmetysObjectResolver)((Object)serviceManager.lookup(AmetysObjectResolver.ROLE));
    }

    public Map<String, Object> getVariables(ScriptExecArguments execArgs) {
        Session session;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Repository repository = this._repositoryProvider.getRepository();
        Credentials credentials = this._repositoryProvider.getCredentials();
        try {
            session = repository.login(credentials, "default");
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to provides the JavaScript console with repository variables.", (Throwable)e);
            return null;
        }
        variables.put("__internal_repository_repository", new RepositoryWrapper(this, repository));
        variables.put("__internal_repository_session", session);
        variables.put("__internal_repository_objectResolver", (Object)this._ametysResolver);
        return variables;
    }

    public void cleanVariables(Map<String, Object> variables) {
        Object session;
        if (variables.containsKey("__internal_repository_session") && (session = variables.get("__internal_repository_session")) != null && session instanceof Session) {
            ((Session)session).logout();
            variables.remove("__internal_repository_session");
        }
    }

    private class RepositoryWrapper
    implements Repository {
        private Repository _repo;

        RepositoryWrapper(RepositoryScriptBinding repositoryScriptBinding, Repository repo) {
            this._repo = repo;
        }

        public String getDescriptor(String key) {
            return this._repo.getDescriptor(key);
        }

        public String[] getDescriptorKeys() {
            return this._repo.getDescriptorKeys();
        }

        public Value getDescriptorValue(String key) {
            return this._repo.getDescriptorValue(key);
        }

        public Value[] getDescriptorValues(String key) {
            return this._repo.getDescriptorValues(key);
        }

        public boolean isSingleValueDescriptor(String key) {
            return this._repo.isSingleValueDescriptor(key);
        }

        public boolean isStandardDescriptor(String key) {
            return this._repo.isStandardDescriptor(key);
        }

        public Session login() throws LoginException, RepositoryException {
            return this._repo.login();
        }

        public Session login(Credentials credentials) throws LoginException, RepositoryException {
            return this._repo.login(credentials);
        }

        public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
            return this._repo.login(workspaceName);
        }

        public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
            return this._repo.login(credentials, workspaceName);
        }
    }
}

