/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.ametys.plugins.core.ui.script.ScriptHandler;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;

public class RepositoryScriptHandler
extends ScriptHandler {
    protected ScriptHandler.ResultProcessor getProcessor() {
        return new RepositoryResultProcessor();
    }

    static class RepositoryResultProcessor
    extends ScriptHandler.ResultProcessor {
        RepositoryResultProcessor() {
        }

        protected Object process(Map<String, Object> results, Object scriptResult) {
            try {
                if (scriptResult instanceof Node) {
                    Node node = (Node)scriptResult;
                    return this._process(node);
                }
                if (scriptResult instanceof NodeIterator) {
                    ArrayList<Object> nodePaths = new ArrayList<Object>();
                    NodeIterator nodeIt = (NodeIterator)scriptResult;
                    while (nodeIt.hasNext()) {
                        nodePaths.add(this._process(nodeIt.nextNode()));
                    }
                    return nodePaths;
                }
                if (scriptResult instanceof AmetysObject) {
                    AmetysObject object = (AmetysObject)scriptResult;
                    return this._process(object);
                }
                if (scriptResult instanceof AmetysObjectIterable) {
                    Iterator iterator = ((AmetysObjectIterable)scriptResult).iterator();
                    ArrayList<Object> objects = new ArrayList<Object>();
                    while (iterator.hasNext()) {
                        objects.add(this._process((AmetysObject)iterator.next()));
                    }
                    return objects;
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            return super.process(results, scriptResult);
        }

        private Object _process(Node node) throws RepositoryException {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("type", "node");
            props.put("path", node.getPath());
            props.put("workspace", node.getSession().getWorkspace().getName());
            return props;
        }

        private Object _process(AmetysObject object) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("type", "ametys-object");
            props.put("path", object.getPath());
            props.put("id", object.getId());
            return props;
        }
    }
}

