/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.script;

import java.lang.reflect.Array;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class RepositoryScriptHelper {
    private RepositoryScriptHelper() {
    }

    public static void setProperty(Node node, String name, Object values) throws RepositoryException {
        Object[] javaValues = values;
        if (values instanceof List) {
            List list = (List)values;
            if (list.isEmpty()) {
                javaValues = new Value[]{};
            } else if (list.get(0) instanceof String) {
                javaValues = list.toArray(new String[list.size()]);
            } else if (list.get(0) instanceof Value) {
                javaValues = list.toArray(new Value[list.size()]);
            }
        }
        RepositoryScriptHelper._setProperty(node, name, javaValues);
    }

    private static void _setProperty(Node node, String name, Object values) throws RepositoryException {
        if (values instanceof String[]) {
            node.setProperty(name, (String[])values);
        } else if (values instanceof Value[]) {
            node.setProperty(name, (Value[])values);
        } else if (values instanceof String) {
            node.setProperty(name, (String)values);
        } else if (values instanceof Boolean) {
            node.setProperty(name, ((Boolean)values).booleanValue());
        } else if (values instanceof Long) {
            node.setProperty(name, ((Long)values).longValue());
        } else if (values instanceof Integer) {
            node.setProperty(name, ((Integer)values).longValue());
        } else if (values instanceof Double) {
            node.setProperty(name, ((Double)values).doubleValue());
        } else if (values instanceof Float) {
            node.setProperty(name, ((Float)values).doubleValue());
        } else {
            Class<?> clazz = values.getClass();
            throw new IllegalArgumentException("argument values (" + String.valueOf(values) + ") is of unsupported type by RepositoryScriptHelper#setProperty: '" + String.valueOf(clazz) + "'");
        }
    }

    public static boolean convertSingleToMultipleProperty(Node node, String propertyName) throws RepositoryException {
        Property property;
        boolean needSave = false;
        if (node.hasProperty(propertyName) && !(property = node.getProperty(propertyName)).getDefinition().isMultiple()) {
            Value value = property.getValue();
            if (value.getType() == 1) {
                String valueAsStr = value.getString();
                property.remove();
                if (!StringUtils.isEmpty((CharSequence)valueAsStr)) {
                    String[] strArray = value.getString().split(",");
                    node.setProperty(propertyName, strArray);
                } else {
                    node.setProperty(propertyName, new String[0]);
                }
            } else {
                Value[] values = (Value[])ArrayUtils.toArray((Object[])new Value[]{value});
                node.setProperty(propertyName, values);
            }
            needSave = true;
        }
        return needSave;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setModelLessValue(ModifiableModelLessDataHolder dataHolder, String name, Object value, String type) {
        if (value instanceof List) {
            List list = (List)value;
            ModelItemType modelItemType = (ModelItemType)dataHolder.getModelItemTypeExtensionPoint().getExtension(type);
            if (modelItemType == null) {
                throw new BadItemTypeException("Type '" + type + "'does not exist for the given DataHolder (" + dataHolder.getRepositoryData().toString() + "). Impossible to use setValue with it.");
            }
            if (!(modelItemType instanceof ElementType)) throw new BadItemTypeException("Type '" + type + "'is not associated with an ElementType. Impossible to use setValue with it.");
            ElementType elementType = (ElementType)modelItemType;
            Class managedClass = elementType.getManagedClass();
            Object[] array = (Object[])Array.newInstance(managedClass, list.size());
            dataHolder.setValue(name, list.toArray(array), type);
            return;
        } else {
            dataHolder.setValue(name, value, type);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setModelAwareValue(ModifiableModelAwareDataHolder dataHolder, String name, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            Object itemType = dataHolder.getType(name);
            if (!(itemType instanceof ElementType)) throw new BadItemTypeException("Item at path '" + name + "' is not associated with an ElementType. Impossible to use setValue with it.");
            ElementType elementType = (ElementType)itemType;
            Class managedClass = elementType.getManagedClass();
            Object[] array = (Object[])Array.newInstance(managedClass, list.size());
            dataHolder.setValue(name, list.toArray(array));
            return;
        } else {
            dataHolder.setValue(name, value);
        }
    }
}

