/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.tag;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.DefaultAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;

public final class TaggableAmetysObjectHelper {
    public static final String DEFAULT_METADATA_TAGS = "ametys-internal:tags";

    private TaggableAmetysObjectHelper() {
    }

    public static Set<String> getTags(JCRAmetysObject object) throws AmetysRepositoryException {
        return TaggableAmetysObjectHelper.getTags(object, DEFAULT_METADATA_TAGS);
    }

    public static Set<String> getTags(JCRAmetysObject object, String metadataName) throws AmetysRepositoryException {
        try {
            Node node = TaggableAmetysObjectHelper.getNode(object);
            Value[] values = node.getProperty(metadataName).getValues();
            HashSet<String> tags = new HashSet<String>(values.length);
            for (Value value : values) {
                tags.add(value.getString());
            }
            return tags;
        }
        catch (PathNotFoundException e) {
            return Collections.emptySet();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get tags property " + metadataName, e);
        }
    }

    public static void tag(JCRAmetysObject object, String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.tag(object, tag, DEFAULT_METADATA_TAGS);
    }

    public static void tag(JCRAmetysObject object, String tag, String metadataName) throws AmetysRepositoryException {
        try {
            Node node = TaggableAmetysObjectHelper.getNode(object);
            Value[] values = new Value[]{};
            if (node.hasProperty(metadataName)) {
                values = node.getProperty(metadataName).getValues();
            }
            HashSet<String> tags = new HashSet<String>(values.length + 1);
            for (Value value : values) {
                tags.add(value.getString());
            }
            if (tags.add(tag)) {
                ValueFactory valueFactory = node.getSession().getValueFactory();
                HashSet<Value> newValues = new HashSet<Value>(tags.size());
                for (String currentTag : tags) {
                    newValues.add(valueFactory.createValue(currentTag));
                }
                node.setProperty(metadataName, newValues.toArray(new Value[newValues.size()]));
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set tags property", e);
        }
    }

    public static void untag(JCRAmetysObject object, String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.untag(object, tag, DEFAULT_METADATA_TAGS);
    }

    public static void untag(JCRAmetysObject object, String tag, String metadataName) throws AmetysRepositoryException {
        try {
            Node node = TaggableAmetysObjectHelper.getNode(object);
            Value[] values = new Value[]{};
            if (node.hasProperty(metadataName)) {
                values = node.getProperty(metadataName).getValues();
            }
            HashSet<String> tags = new HashSet<String>(values.length + 1);
            for (Value value : values) {
                tags.add(value.getString());
            }
            if (tags.remove(tag)) {
                ValueFactory valueFactory = node.getSession().getValueFactory();
                HashSet<Value> newValues = new HashSet<Value>(tags.size());
                for (String currentTag : tags) {
                    newValues.add(valueFactory.createValue(currentTag));
                }
                node.setProperty(metadataName, newValues.toArray(new Value[newValues.size()]));
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set tags property", e);
        }
    }

    protected static Node getNode(JCRAmetysObject object) {
        Node node = null;
        node = object instanceof DefaultAmetysObject ? ((DefaultAmetysObject)object).getBaseNode() : object.getNode();
        return node;
    }
}

