/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.workspace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.metadata.MetadataAwareAmetysObject;
import org.ametys.plugins.repository.metadata.ModifiableCompositeMetadata;
import org.ametys.plugins.repository.metadata.ModifiableMetadataAwareAmetysObject;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class AmetysObjectDao
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)((Object)serviceManager.lookup(AmetysObjectResolver.ROLE));
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/repository")
    public Map<String, Object> getAmetysObject(String id) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Getting AmetysObject from ID '" + id + "'");
        }
        Object obj = this._resolver.resolveById(id);
        HashMap<String, Object> info = new HashMap<String, Object>();
        this.putAmetysObjectInfo((Map<String, Object>)info, (AmetysObject)obj);
        return info;
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/repository")
    public Map<String, Object> getAmetysObjectByPath(String path) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Getting AmetysObject at path '" + path + "'");
        }
        Object obj = this._resolver.resolveByPath(path);
        HashMap<String, Object> info = new HashMap<String, Object>();
        this.putAmetysObjectInfo((Map<String, Object>)info, (AmetysObject)obj);
        return info;
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/repository")
    public Map<String, Object> getAmetysObjects(Collection<String> ids) {
        ArrayList<HashMap<String, Object>> objects = new ArrayList<HashMap<String, Object>>();
        ArrayList<String> notFound = new ArrayList<String>();
        for (String id : ids) {
            try {
                AmetysObject obj = null;
                obj = "/".equals(id) ? (AmetysObject)this._resolver.resolveByPath("/") : (AmetysObject)this._resolver.resolveById(id);
                HashMap<String, Object> objectInfo = new HashMap<String, Object>();
                this.putAmetysObjectInfo(objectInfo, obj);
                objects.add(objectInfo);
            }
            catch (UnknownAmetysObjectException e) {
                notFound.add(id);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("objects", objects);
        result.put("notFound", notFound);
        return result;
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/repository")
    public Map<String, Object> addAmetysObject(String parentId, String name, String type) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Trying to add child: '" + name + "' to the AmetysObject of id '" + parentId + "'");
        }
        Object obj = null;
        obj = parentId.equals("/") ? this._resolver.resolveByPath("/") : this._resolver.resolveById(parentId);
        if (!(obj instanceof ModifiableTraversableAmetysObject)) {
            throw new IllegalArgumentException();
        }
        Object child = ((ModifiableTraversableAmetysObject)obj).createChild(name, type);
        ((ModifiableTraversableAmetysObject)obj).saveChanges();
        HashMap<String, Object> childInfo = new HashMap<String, Object>();
        this.putAmetysObjectInfo((Map<String, Object>)childInfo, (AmetysObject)child);
        return childInfo;
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/repository")
    public void removeAmetysObject(String id) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Trying to remove the AmetysObject of id '" + id + "'");
        }
        AmetysObject obj = null;
        obj = id.equals("/") ? (AmetysObject)this._resolver.resolveByPath("/") : (AmetysObject)this._resolver.resolveById(id);
        if (obj instanceof RemovableAmetysObject) {
            ModifiableAmetysObject parent = (ModifiableAmetysObject)obj.getParent();
            ((RemovableAmetysObject)obj).remove();
            parent.saveChanges();
        }
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/repository")
    public void removeMetadata(String id, String compositePath, String metadataName) {
        Object obj = null;
        obj = id.equals("/") ? this._resolver.resolveByPath("/") : this._resolver.resolveById(id);
        if (obj instanceof ModifiableMetadataAwareAmetysObject) {
            ModifiableCompositeMetadata holder = ((ModifiableMetadataAwareAmetysObject)obj).getMetadataHolder();
            if (StringUtils.isNotEmpty((CharSequence)compositePath) && !compositePath.isEmpty()) {
                String[] tokens = compositePath.split("/");
                for (int i = 0; i < tokens.length; ++i) {
                    holder = holder.getCompositeMetadata(tokens[i]);
                }
            }
            holder.removeMetadata(metadataName);
            ((ModifiableMetadataAwareAmetysObject)obj).saveChanges();
        }
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/repository")
    public void unlockAmetysObject(String id) {
        LockableAmetysObject lockableObject;
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Trying to unlock the AmetysObject of id '" + id + "'");
        }
        Object obj = null;
        obj = id.equals("/") ? this._resolver.resolveByPath("/") : this._resolver.resolveById(id);
        if (obj instanceof LockableAmetysObject && (lockableObject = (LockableAmetysObject)obj).isLocked()) {
            lockableObject.unlock();
        }
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/repository")
    public List<Map<String, Object>> query(String query) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Executing logic query: " + query);
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            AmetysObjectIterable objects = this._resolver.query(query);
            for (AmetysObject object : objects) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("id", object.getId());
                result.put("name", object.getName());
                result.put("path", object.getPath());
                results.add(result);
            }
        }
        return results;
    }

    protected void putAmetysObjectInfo(Map<String, Object> info, AmetysObject obj) {
        try {
            info.put("id", obj.getId());
            info.put("name", obj.getName());
            info.put("path", obj.getPath());
            info.put("metadataAware", obj instanceof MetadataAwareAmetysObject);
            info.put("modifiable", obj instanceof ModifiableAmetysObject);
            info.put("modifiableTraversable", obj instanceof ModifiableTraversableAmetysObject);
            if (obj instanceof JCRAmetysObject) {
                info.put("jcrAo", true);
                info.put("jcrPath", ((JCRAmetysObject)obj).getNode().getPath());
            }
            if (obj instanceof LockAwareAmetysObject) {
                info.put("locked", ((LockAwareAmetysObject)obj).isLocked());
                info.put("lockable", obj instanceof LockableAmetysObject);
            } else {
                info.put("lockable", false);
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error getting information on the object " + obj.toString(), e);
        }
    }
}

