/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.workspace;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.metadata.BinaryMetadata;
import org.ametys.plugins.repository.metadata.CompositeMetadata;
import org.ametys.plugins.repository.metadata.File;
import org.ametys.plugins.repository.metadata.Folder;
import org.ametys.plugins.repository.metadata.ModifiableMetadataAwareAmetysObject;
import org.ametys.plugins.repository.metadata.RichText;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceUtil;
import org.xml.sax.SAXException;

public class BinaryMetadataReader
extends AbstractReader
implements Serviceable {
    private AmetysObjectResolver _resolver;
    private String _mimeType;
    private String _mdName;
    private String _compositePath;
    private String _richtextPath;
    private String _mdType;
    private String _aoId;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
    }

    public void setup(SourceResolver res, Map objModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        super.setup(res, objModel, src, params);
        try {
            this._mimeType = params.getParameter("mime-type");
            this._mdName = params.getParameter("name");
            this._compositePath = params.getParameter("compositePath");
            this._richtextPath = params.getParameter("richtextPath");
            this._mdType = params.getParameter("type");
            this._aoId = params.getParameter("id");
        }
        catch (ParameterException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
    }

    public String getMimeType() {
        if (!StringUtils.isEmpty((CharSequence)this._mimeType)) {
            return this._mimeType;
        }
        return this._getMimeType();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            String filename = null;
            long length = 0L;
            AmetysObject ao = this._getAmetysObject();
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Trying to read a binary for object of id: '" + this._aoId + "'");
            }
            CompositeMetadata holder = this._getCompositeMetadata(ao);
            InputStream is = null;
            if (this._mdType.equals("RICHTEXT-CONTENT")) {
                rtTokens = this._richtextPath.split("/");
                RichText rt = holder.getRichText(rtTokens[0]);
                length = rt.getLength();
                filename = rtTokens[0];
                is = rt.getInputStream();
            } else if (this._mdType.equals("RICHTEXT")) {
                RichText rt = holder.getRichText(this._mdName);
                length = rt.getLength();
                filename = this._mdName;
                is = rt.getInputStream();
            } else if (this._mdType.equals("BINARY")) {
                BinaryMetadata binaryMetadata = holder.getBinaryMetadata(this._mdName);
                filename = binaryMetadata.getFilename();
                is = binaryMetadata.getInputStream();
                length = binaryMetadata.getLength();
            } else if (this._mdType.equals("FILE-CONTENT")) {
                rtTokens = this._richtextPath.split("/");
                RichText rt = holder.getRichText(rtTokens[0]);
                length = rt.getLength();
                Folder folder = rt.getAdditionalDataFolder();
                for (int i = 2; i < rtTokens.length - 1; ++i) {
                    folder = folder.getFolder(rtTokens[i]);
                }
                File file = folder.getFile(rtTokens[rtTokens.length - 1]);
                filename = file.getName();
                is = file.getResource().getInputStream();
            }
            Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
            response.setHeader("Content-Length", Long.toString(length));
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
            SourceUtil.copy((InputStream)is, (OutputStream)this.out);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to download binary property of path " + this._mdName, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }

    private CompositeMetadata _getCompositeMetadata(AmetysObject ao) {
        CompositeMetadata holder = ((ModifiableMetadataAwareAmetysObject)ao).getMetadataHolder();
        if (!this._compositePath.isEmpty()) {
            String[] tokens;
            for (String token : tokens = this._compositePath.split("/")) {
                holder = holder.getCompositeMetadata(token);
            }
        }
        return holder;
    }

    private String _getMimeType() {
        AmetysObject ao = this._getAmetysObject();
        CompositeMetadata holder = this._getCompositeMetadata(ao);
        if (this._mdType.equals("RICHTEXT-CONTENT")) {
            String[] rtTokens = this._richtextPath.split("/");
            RichText rt = holder.getRichText(rtTokens[0]);
            return rt.getMimeType();
        }
        if (this._mdType.equals("RICHTEXT")) {
            return holder.getRichText(this._mdName).getMimeType();
        }
        if (this._mdType.equals("BINARY")) {
            return holder.getBinaryMetadata(this._mdName).getMimeType();
        }
        if (this._mdType.equals("FILE-CONTENT")) {
            String[] rtTokens = this._richtextPath.split("/");
            RichText rt = holder.getRichText(rtTokens[0]);
            Folder folder = rt.getAdditionalDataFolder();
            for (int i = 2; i < rtTokens.length - 1; ++i) {
                folder = folder.getFolder(rtTokens[i]);
            }
            File file = folder.getFile(rtTokens[rtTokens.length - 1]);
            return file.getResource().getMimeType();
        }
        return "application/unknown";
    }

    private AmetysObject _getAmetysObject() {
        if (this._aoId.equals("/")) {
            return this._resolver.resolveByPath("/");
        }
        return this._resolver.resolveById(this._aoId);
    }
}

