/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.workspace;

import java.io.IOException;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class QueryLogicResultGenerator
extends AbstractGenerator
implements Serviceable {
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)((Object)manager.lookup(AmetysObjectResolver.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Trying to generate results for a XPath query (logic view)");
        }
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"resultList");
        String query = this.parameters.getParameter("query", "");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            try {
                this._populateQueryResult(query);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to execute logic query '" + query + "'", (Throwable)e);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"error", (String)e.toString());
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"resultList");
        this.contentHandler.endDocument();
    }

    private void _populateQueryResult(String query) throws SAXException {
        AmetysObjectIterable itResults = this._resolver.query(query);
        for (AmetysObject ao : itResults) {
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("id", ao.getId());
            attr.addCDATAAttribute("path", ao.getPath());
            attr.addCDATAAttribute("name", ao.getName());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"result", (Attributes)attr);
        }
    }
}

