/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.workspace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.metadata.CompositeMetadata;
import org.ametys.plugins.repository.metadata.File;
import org.ametys.plugins.repository.metadata.Folder;
import org.ametys.plugins.repository.metadata.MetadataAwareAmetysObject;
import org.ametys.plugins.repository.metadata.RichText;
import org.ametys.workspaces.repository.jcr.NodeGroupHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RepositoryLogicNodeGenerator
extends ServiceableGenerator {
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)((Object)serviceManager.lookup(AmetysObjectResolver.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Trying to generate content for a node");
        }
        String id = this.parameters.getParameter("id", "");
        this.contentHandler.startDocument();
        AttributesImpl repositoryAttributes = new AttributesImpl();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"repository", (Attributes)repositoryAttributes);
        try {
            this._saxObject(id);
        }
        catch (RepositoryException e) {
            throw new ProcessingException("Unable to retrieve node for path: '" + this.source + "'", (Throwable)e);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"repository");
        this.contentHandler.endDocument();
    }

    private void _saxObject(String id) throws SAXException, RepositoryException {
        AmetysObject ao = null;
        ao = StringUtils.isEmpty((CharSequence)id) || id.equals("/") ? (AmetysObject)this._resolver.resolveByPath("/") : (AmetysObject)this._resolver.resolveById(id);
        boolean isModifiable = ao instanceof ModifiableAmetysObject;
        boolean isLocked = ao instanceof LockAwareAmetysObject && ((LockAwareAmetysObject)ao).isLocked();
        AttributesImpl nodeAttributes = new AttributesImpl();
        nodeAttributes.addCDATAAttribute("path", ao.getPath());
        nodeAttributes.addCDATAAttribute("name", ao.getName());
        nodeAttributes.addCDATAAttribute("id", ao.getId());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"ametysObject", (Attributes)nodeAttributes);
        Attributes attrs = XMLUtils.EMPTY_ATTRIBUTES;
        if (ao instanceof MetadataAwareAmetysObject) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isMetadataAware", (Attributes)attrs, (String)"true");
            CompositeMetadata holder = ((MetadataAwareAmetysObject)ao).getMetadataHolder();
            this._saxMetaData(holder, isLocked, isModifiable);
        } else {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isMetadataAware", (Attributes)attrs, (String)"false");
        }
        if (ao instanceof TraversableAmetysObject) {
            this._saxChildren((TraversableAmetysObject)ao);
        }
        if (ao instanceof JCRAmetysObject) {
            Node node = ((JCRAmetysObject)ao).getNode();
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isJCRAO", (Attributes)attrs, (String)"true");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"JCRPath", (Attributes)attrs, (String)node.getPath());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"JCRPathWithGroups", (Attributes)attrs, (String)NodeGroupHelper.getPathWithGroups((Node)node));
        } else {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isJCRAO", (Attributes)attrs, (String)"false");
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isModifiable", (Attributes)attrs, (String)Boolean.toString(isModifiable));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isModifiableTraversable", (Attributes)attrs, (String)Boolean.toString(ao instanceof ModifiableTraversableAmetysObject));
        if (ao instanceof LockAwareAmetysObject) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isLocked", (Attributes)attrs, (String)Boolean.toString(isLocked));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isLockable", (Attributes)attrs, (String)Boolean.toString(ao instanceof LockableAmetysObject));
        } else {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isLocked", (Attributes)attrs, (String)"not-applicable");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"isLockable", (Attributes)attrs, (String)"false");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"ametysObject");
    }

    private void _saxMetaData(CompositeMetadata holder, boolean isLocked, boolean isModifiable) throws SAXException, RepositoryException {
        String[] metadataNames = holder.getMetadataNames();
        ArrayList<String> metaNames = new ArrayList<String>(Arrays.asList(metadataNames));
        Collections.sort(metaNames);
        for (String name : metaNames) {
            AttributesImpl metadataAttributes = new AttributesImpl();
            CompositeMetadata.MetadataType type = holder.getType(name);
            Boolean isMultiple = holder.isMultiple(name);
            metadataAttributes.addCDATAAttribute("name", name);
            metadataAttributes.addCDATAAttribute("type", type.toString());
            metadataAttributes.addCDATAAttribute("multiple", Boolean.toString(isMultiple));
            metadataAttributes.addCDATAAttribute("editable", Boolean.toString(type != CompositeMetadata.MetadataType.COMPOSITE && isModifiable && !isLocked));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)metadataAttributes);
            this._saxValues(holder, name, type, isMultiple, isLocked, isModifiable);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        }
    }

    private void _saxChildren(TraversableAmetysObject ao) throws SAXException, RepositoryException {
        AmetysObjectIterable children = ao.getChildren();
        for (AmetysObject child : children) {
            String id = child.getId();
            String name = child.getName();
            AttributesImpl childAttributes = new AttributesImpl();
            childAttributes.addCDATAAttribute("name", name);
            childAttributes.addCDATAAttribute("id", id);
            childAttributes.addCDATAAttribute("path", child.getPath());
            if (child instanceof JCRAmetysObject) {
                Node node = ((JCRAmetysObject)child).getNode();
                childAttributes.addCDATAAttribute("isJCRAO", "true");
                childAttributes.addCDATAAttribute("JCRPath", node.getPath());
                childAttributes.addCDATAAttribute("JCRPathWithGroups", NodeGroupHelper.getPathWithGroups((Node)node));
            }
            if (!(child instanceof TraversableAmetysObject)) {
                childAttributes.addCDATAAttribute("noChild", "true");
            } else if (!((TraversableAmetysObject)child).getChildren().iterator().hasNext()) {
                childAttributes.addCDATAAttribute("noChild", "true");
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"ametysObject", (Attributes)childAttributes);
        }
    }

    private void _saxValues(CompositeMetadata holder, String name, CompositeMetadata.MetadataType type, Boolean isMultiple, boolean isLocked, boolean isModifiable) throws RepositoryException, SAXException {
        if (isMultiple.booleanValue()) {
            this._saxMultipleValues(holder, name, type, isLocked, isModifiable);
        } else {
            this._saxSimpleValue(holder, name, type, isLocked, isModifiable);
        }
    }

    private void _saxMultipleValues(CompositeMetadata holder, String name, CompositeMetadata.MetadataType type, boolean isLocked, boolean isModifiable) throws RepositoryException, SAXException {
        Attributes attrs = XMLUtils.EMPTY_ATTRIBUTES;
        String textValue = null;
        switch (type) {
            case DATE: {
                Date[] dateValues;
                for (Date dVal : dateValues = holder.getDateArray(name)) {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)DateUtils.dateToString((Date)dVal));
                }
                break;
            }
            case STRING: {
                String[] stringValues;
                String[] stringArray = stringValues = holder.getStringArray(name);
                int n = stringArray.length;
                for (int dVal = 0; dVal < n; ++dVal) {
                    String sVal;
                    textValue = sVal = stringArray[dVal];
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
                }
                break;
            }
            case LONG: {
                long[] longValues;
                for (long lVal : longValues = holder.getLongArray(name)) {
                    textValue = Long.toString(lVal);
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues;
                for (double dbVal : doubleValues = holder.getDoubleArray(name)) {
                    textValue = Double.toString(dbVal);
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] booleanValues;
                for (boolean bVal : booleanValues = holder.getBooleanArray(name)) {
                    textValue = Boolean.toString(bVal);
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
                }
                break;
            }
            case COMPOSITE: {
                CompositeMetadata cm = holder.getCompositeMetadata(name);
                this._saxMetaData(cm, isLocked, isModifiable);
                break;
            }
            case BINARY: {
                String mimeType = holder.getBinaryMetadata(name).getMimeType();
                AttributesImpl attrsimpl = new AttributesImpl();
                attrsimpl.addCDATAAttribute("mime-type", mimeType);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrsimpl);
                break;
            }
            case RICHTEXT: {
                RichText rt = holder.getRichText(name);
                this._saxRichText(rt);
                break;
            }
            case OBJECT_COLLECTION: {
                break;
            }
            default: {
                textValue = "";
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
            }
        }
    }

    private void _saxSimpleValue(CompositeMetadata holder, String name, CompositeMetadata.MetadataType type, boolean isLocked, boolean isModifiable) throws RepositoryException, SAXException {
        Attributes attrs = XMLUtils.EMPTY_ATTRIBUTES;
        String textValue = null;
        switch (type) {
            case DATE: {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)DateUtils.dateToString((Date)holder.getDate(name)));
                break;
            }
            case STRING: {
                textValue = holder.getString(name);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
                break;
            }
            case LONG: {
                textValue = Long.toString(holder.getLong(name));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
                break;
            }
            case DOUBLE: {
                textValue = Double.toString(holder.getDouble(name));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
                break;
            }
            case BOOLEAN: {
                textValue = Boolean.toString(holder.getBoolean(name));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
                break;
            }
            case COMPOSITE: {
                CompositeMetadata cm = holder.getCompositeMetadata(name);
                this._saxMetaData(cm, isLocked, isModifiable);
                break;
            }
            case BINARY: {
                String mimeType = holder.getBinaryMetadata(name).getMimeType();
                AttributesImpl attrsimpl = new AttributesImpl();
                attrsimpl.addCDATAAttribute("mime-type", mimeType);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrsimpl);
                break;
            }
            case RICHTEXT: {
                RichText rt = holder.getRichText(name);
                this._saxRichText(rt);
                break;
            }
            case OBJECT_COLLECTION: {
                break;
            }
            default: {
                textValue = "";
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs, (String)textValue);
            }
        }
    }

    private void _saxRichText(RichText rt) throws RepositoryException, SAXException {
        AttributesImpl contentAttributes = new AttributesImpl();
        contentAttributes.addCDATAAttribute("name", "data");
        contentAttributes.addCDATAAttribute("type", "RICHTEXT-CONTENT");
        contentAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)contentAttributes);
        AttributesImpl attrsimplRT = new AttributesImpl();
        attrsimplRT.addCDATAAttribute("mime-type", rt.getMimeType());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrsimplRT);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        if (rt.getEncoding() != null) {
            AttributesImpl encodingAttributes = new AttributesImpl();
            encodingAttributes.addCDATAAttribute("name", "encoding");
            encodingAttributes.addCDATAAttribute("type", "STRING");
            encodingAttributes.addCDATAAttribute("isMultiple", "false");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)encodingAttributes);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES, (String)rt.getEncoding());
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        }
        AttributesImpl mimeAttributes = new AttributesImpl();
        mimeAttributes.addCDATAAttribute("name", "mime-type");
        mimeAttributes.addCDATAAttribute("type", "STRING");
        mimeAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)mimeAttributes);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES, (String)rt.getMimeType());
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        AttributesImpl lastmodAttributes = new AttributesImpl();
        lastmodAttributes.addCDATAAttribute("name", "last-modified-date");
        lastmodAttributes.addCDATAAttribute("type", "DATE");
        lastmodAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)lastmodAttributes);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES, (String)DateUtils.dateToString((Date)rt.getLastModified()));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        AttributesImpl lengthAttributes = new AttributesImpl();
        lengthAttributes.addCDATAAttribute("name", "length");
        lengthAttributes.addCDATAAttribute("type", "LONG");
        lengthAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)lengthAttributes);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES, (String)Long.toString(rt.getLength()));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        this._saxFolder(rt.getAdditionalDataFolder());
    }

    private void _saxFolder(Folder folder) throws RepositoryException, SAXException {
        AttributesImpl folderAttributes = new AttributesImpl();
        folderAttributes.addCDATAAttribute("name", folder.getName());
        folderAttributes.addCDATAAttribute("type", "FOLDER");
        folderAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)folderAttributes);
        Collection<? extends Folder> folders = folder.getFolders();
        for (Folder folder2 : folders) {
            this._saxFolder(folder2);
        }
        Collection<? extends File> collection = folder.getFiles();
        for (File file : collection) {
            this._saxFile(file);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
    }

    private void _saxFile(File file) throws SAXException {
        AttributesImpl fileAttributes = new AttributesImpl();
        fileAttributes.addCDATAAttribute("name", file.getName());
        fileAttributes.addCDATAAttribute("type", "FILE");
        fileAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)fileAttributes);
        AttributesImpl contentAttributes = new AttributesImpl();
        contentAttributes.addCDATAAttribute("name", "data");
        contentAttributes.addCDATAAttribute("type", "FILE-CONTENT");
        contentAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)contentAttributes);
        AttributesImpl attrsimplF = new AttributesImpl();
        attrsimplF.addCDATAAttribute("mime-type", file.getResource().getMimeType());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrsimplF);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        if (file.getResource().getEncoding() != null) {
            AttributesImpl encodingAttributes = new AttributesImpl();
            encodingAttributes.addCDATAAttribute("name", "encoding");
            encodingAttributes.addCDATAAttribute("type", "STRING");
            encodingAttributes.addCDATAAttribute("isMultiple", "false");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)encodingAttributes);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES, (String)file.getResource().getEncoding());
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        }
        AttributesImpl mimeAttributes = new AttributesImpl();
        mimeAttributes.addCDATAAttribute("name", "mime-type");
        mimeAttributes.addCDATAAttribute("type", "STRING");
        mimeAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)mimeAttributes);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES, (String)file.getResource().getMimeType());
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        AttributesImpl lastmodAttributes = new AttributesImpl();
        lastmodAttributes.addCDATAAttribute("name", "last-modified-date");
        lastmodAttributes.addCDATAAttribute("type", "DATE");
        lastmodAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)lastmodAttributes);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES, (String)DateUtils.dateToString((Date)file.getResource().getLastModified()));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        AttributesImpl lengthAttributes = new AttributesImpl();
        lengthAttributes.addCDATAAttribute("name", "length");
        lengthAttributes.addCDATAAttribute("type", "LONG");
        lengthAttributes.addCDATAAttribute("isMultiple", "false");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"metadata", (Attributes)lengthAttributes);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)XMLUtils.EMPTY_ATTRIBUTES, (String)Long.toString(file.getResource().getLength()));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"metadata");
    }
}

