/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repository.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.metadata.CompositeMetadata;
import org.ametys.plugins.repository.metadata.ModifiableCompositeMetadata;
import org.ametys.plugins.repository.metadata.ModifiableFile;
import org.ametys.plugins.repository.metadata.ModifiableFolder;
import org.ametys.plugins.repository.metadata.ModifiableMetadataAwareAmetysObject;
import org.ametys.plugins.repository.metadata.ModifiableRichText;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SetMetadataAction
extends ServiceableAction {
    static SimpleDateFormat _DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)((Object)serviceManager.lookup(AmetysObjectResolver.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver sourceResolver, Map objectModel, String source, Parameters parameters) throws Exception {
        boolean multiple;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String id = null;
        String name = null;
        String compositePath = null;
        String richtextPath = null;
        String type = null;
        String fileFieldId = null;
        try {
            id = parameters.getParameter("id");
            name = parameters.getParameter("name");
            compositePath = parameters.getParameter("cPath");
            richtextPath = parameters.getParameter("rtPath");
            type = parameters.getParameter("type");
            fileFieldId = parameters.getParameter("filefieldid");
            multiple = parameters.getParameterAsBoolean("multiple", false);
        }
        catch (ParameterException e) {
            throw new ProcessingException("Missing at least one parameter", (Throwable)e);
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Setting metadata '" + name + "' of the AmetysObject of id '" + id + "'");
        }
        Object ao = null;
        ao = id.equals("/") ? this._resolver.resolveByPath("/") : this._resolver.resolveById(id);
        String[] values = request.getParameterValues("value");
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ModifiableCompositeMetadata holder = this._getHolderInComposite(ao, compositePath);
            if (richtextPath.isEmpty()) {
                this._setMetadataOutsideRT(holder, type, name, values, multiple);
            } else if (richtextPath.split("/").length == 1) {
                this._setMetadataInsideRT(request, holder, name, values[0], fileFieldId, richtextPath);
            } else {
                this._setMetadataInsideRTDataFolder(request, holder, name, values[0], fileFieldId, richtextPath);
            }
            ((ModifiableMetadataAwareAmetysObject)ao).saveChanges();
            result.put("success", true);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to set value " + values[0] + " for metadata '" + name + "'", (Throwable)e);
            result.put("success", false);
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof ParseException) {
                Map<String, I18nizableText> params = Collections.singletonMap("error", new I18nizableText(e.getMessage()));
                result.put("message", new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_CREATE_PROP_ERROR_DATE", params));
            }
            result.put("message", e.toString());
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private ModifiableCompositeMetadata _getHolderInComposite(ModifiableMetadataAwareAmetysObject ao, String compositePath) {
        ModifiableCompositeMetadata holder = ao.getMetadataHolder();
        if (!compositePath.isEmpty()) {
            String[] tokens = compositePath.split("/");
            for (int i = 0; i < tokens.length; ++i) {
                holder = holder.getCompositeMetadata(tokens[i]);
            }
        }
        return holder;
    }

    private void _setMetadataOutsideRT(ModifiableCompositeMetadata holder, String type, String name, String[] values, boolean multiple) throws Exception {
        CompositeMetadata.MetadataType mdType = CompositeMetadata.MetadataType.valueOf(type.toUpperCase());
        switch (mdType) {
            case DATE: {
                if (multiple) {
                    Date[] dateValues = (Date[])Arrays.stream(values).map(LambdaUtils.wrap(_DATE_FORMAT::parse)).toArray(Date[]::new);
                    holder.setMetadata(name, dateValues);
                    break;
                }
                Date dateVal = _DATE_FORMAT.parse(values[0]);
                holder.setMetadata(name, dateVal);
                break;
            }
            case STRING: {
                if (multiple) {
                    holder.setMetadata(name, values);
                    break;
                }
                holder.setMetadata(name, values[0]);
                break;
            }
            case LONG: {
                if (multiple) {
                    long[] longValues = Arrays.stream(values).mapToLong(Long::parseLong).toArray();
                    holder.setMetadata(name, longValues);
                    break;
                }
                Long longVal = Long.parseLong(values[0]);
                holder.setMetadata(name, longVal);
                break;
            }
            case DOUBLE: {
                if (multiple) {
                    double[] doubleValues = Arrays.stream(values).mapToDouble(Double::parseDouble).toArray();
                    holder.setMetadata(name, doubleValues);
                    break;
                }
                Double doubleVal = Double.parseDouble(values[0]);
                holder.setMetadata(name, doubleVal);
                break;
            }
            case BOOLEAN: {
                Boolean booleanVal = Boolean.parseBoolean(values[0]);
                holder.setMetadata(name, booleanVal);
                break;
            }
            case COMPOSITE: {
                break;
            }
            case BINARY: {
                break;
            }
            case RICHTEXT: {
                break;
            }
            case OBJECT_COLLECTION: {
                break;
            }
        }
    }

    private void _setMetadataInsideRT(Request request, ModifiableCompositeMetadata holder, String name, String value, String fileFieldId, String richtextPath) throws Exception {
        String[] rtTokens = richtextPath.split("/");
        ModifiableRichText rt = holder.getRichText(rtTokens[0]);
        if (name.equals("mime-type")) {
            rt.setMimeType(value);
        } else if (name.equals("last-modified-date")) {
            Date dateVal = _DATE_FORMAT.parse(value);
            rt.setLastModified(dateVal);
        } else if (name.equals("encoding")) {
            rt.setEncoding(value);
        } else if (name.equals("data")) {
            File uploadedFile;
            PartOnDisk uploadedFilePart = (PartOnDisk)request.get(fileFieldId);
            File file = uploadedFile = uploadedFilePart != null ? uploadedFilePart.getFile() : null;
            if (uploadedFile != null) {
                FileInputStream is = new FileInputStream(uploadedFile);
                rt.setInputStream(is);
            }
        } else if (name.equals("length")) {
            // empty if block
        }
    }

    private void _setMetadataInsideRTDataFolder(Request request, ModifiableCompositeMetadata holder, String name, String value, String fileFieldId, String richtextPath) throws Exception {
        String[] rtTokens = richtextPath.split("/");
        ModifiableRichText rt = holder.getRichText(rtTokens[0]);
        ModifiableFolder folder = rt.getAdditionalDataFolder();
        for (int i = 2; i < rtTokens.length - 1; ++i) {
            folder = folder.getFolder(rtTokens[i]);
        }
        ModifiableFile file = folder.getFile(rtTokens[rtTokens.length - 1]);
        if (name.equals("mime-type")) {
            file.getResource().setMimeType(value);
        } else if (name.equals("last-modified-date")) {
            Date dateVal = _DATE_FORMAT.parse(value);
            file.getResource().setLastModified(dateVal);
        } else if (name.equals("encoding")) {
            file.getResource().setEncoding(value);
        } else if (name.equals("data")) {
            PartOnDisk uploadedFilePart = (PartOnDisk)request.get(fileFieldId);
            File uploadedFile = uploadedFilePart != null ? uploadedFilePart.getFile() : null;
            FileInputStream is = new FileInputStream(uploadedFile);
            file.getResource().setInputStream(is);
        } else if (name.equals("length")) {
            // empty if block
        }
    }
}

