/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * This script prepares the migration plugin.odf.jcr "v2020-1130T0010-ODF-2790".
 * If the first run of the CMS from the add of this migration is in safe mode and
 * the user has to update general configuration, old config values
 * "odf.programs.degree.license", "odf.programs.degree.licensepro" and
 * "odf.programs.degree.master" will be lost. Then it saves the config file before
 * the user update it.
 */

const components = [
    "org.ametys.plugins.repository.upgrade",
    "org.ametys.plugins.workflow.upgrade",
    "org.ametys.plugins.explorer.upgrade",
    "plugin.blog.jcr",
    "plugin.bpm.jcr",
    "plugin.contents.tree.jcr",
    "plugin.contenttypes.editor.jcr",
    "plugin.external.data.jcr",
    "plugin.faq.jcr",
    "plugin.flipbook.jcr",
    "plugin.forms.jcr",
    "plugin.glossary.jcr",
    "plugin.google.calendar.jcr",
    "plugin.inlinemedia.jcr",
    "plugin.maps.jcr",
    "plugin.multimedia.jcr",
    "plugin.myfavorites.jcr",
    "plugin.news.jcr",
    "plugin.odfsync.export.apogee.jcr",
    "plugin.odfsync.export.cdmfr.jcr",
    "plugin.page.subscription.jcr",
    "plugin.proxied.content.jcr",
    "plugin.server.directory.jcr",
    "plugin.socialnetworking.jcr",
    "plugin.sms.jcr",
    "plugin.survey.jcr",
    "plugin.syndication.jcr",
    "plugin.tagcloud.jcr",
    "plugin.thesaurus.jcr",
    "plugin.translationflagging.jcr",
    "plugin.webcontentio.jcr"
];

const versionStorageEP = Ametys.serviceManager.lookup(org.ametys.core.migration.version.storage.VersionStorageExtensionPoint.ROLE);
const versionStorage = versionStorageEP.getExtension('jcr');

for (var component of components)
{
    const versions = versionStorage.getVersions(component, null, null);
    
    if (versions.length > 1)
    {
        throw "Unexpected non-empty component " + component + ": " + versions;
    }
  
    if (versions.length == 1 && versions.get(0).getVersionNumber() != "0")
    {
      throw "Unexpected version number for component " + component + ": " + versions;
    }
    
    logger.info("Removing useless component " + component);
    versionStorage.removeAllVersions(component, null);
}
