/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class represents an AmetysObject.
 */
Ext.define('Ametys.plugins.repository.AmetysObject',
{
    config: {
        /**
         * @cfg {String} id The unique id of the AmetysObject
         */
        /**
         * @method getId Get the #cfg-id
         * @return {String} The id
         */
        /** @ignore */
        id: null,
        /**
         * @cfg {String} name The name of the AmetysObject
         */
        /**
         * @method getName Get the #cfg-name
         * @return {String} The name
         */
        /** @ignore */
        name: null,
        /**
         * @cfg {String} rootId The AmetysObject path.
         */
        /**
         * @method getPath Get the #cfg-path
         * @return {String} The AmetysObject path.
         */
        /** @ignore */
        path: null,
        /**
         * @cfg {Boolean} locked `true` if the AmetysObject is locked
         */
        /**
         * @method isLocked Test if the AmetysObject is locked
         * @return {Boolean} `true` if the AmetysObject is locked.
         */
        /** @ignore */
        locked: false,
        /**
         * @cfg {Boolean} lockable `true` if the AmetysObject is lockable
         */
        /**
         * @method isLockable Test if the AmetysObject is lockable
         * @return {Boolean} `true` if the AmetysObject is lockable.
         */
        /** @ignore */
        lockable: false,
        /**
         * @cfg {Boolean} jcrAo `true` if the object is a JCRAmetysObject.
         */
        /**
         * @method isJcrAo Test if the object is a JCRAmetysObject.
         * @return {Boolean} `true` if the object is a JCRAmetysObject.
         */
        /** @ignore */
        jcrAo: false,
        /**
         * @cfg {String} jcrPath In case of a JCR AmetysObject, the path of the corresponding JCR node.
         */
        /**
         * @method getJcrPath Get the path of the corresponding JCR node.
         * @return {String} The path of the corresponding JCR node.
         */
        /** @ignore */
        jcrPath: null,
        /**
         * @cfg {Boolean} modifiable `true` if the AmetysObject is modifiable
         */
        /**
         * @method isModifiable Test if the AmetysObject is modifiable
         * @return {Boolean} `true` if the AmetysObject is modifiable.
         */
        /** @ignore */
        modifiable: false,
        /**
         * @cfg {Boolean} modifiableTraversable `true` if the AmetysObject is modifiable and traversable.
         */
        /**
         * @method isModifiableTraversable Test if the AmetysObject is modifiable and traversable
         * @return {Boolean} `true` if the AmetysObject is modifiable and traversable.
         */
        /** @ignore */
        modifiableTraversable: false
    },
    
    /**
     * Creates a node instance
     * @param {Object} config See configuration doc.
     */
    constructor: function(config)
    {
        this.initConfig(config);
    },
    
    /**
     * Get the AmetysObject's properties
     * @return {Object} the AmetysObject's properties
     */
    getProperties: function(initialProperty)
    {
        return Ext.apply({
            id: this._id,
            name: this._name,
            path: this._path,
            locked: this._locked,
            lockable: this._lockable,
            jcrAo: this._jcrAo,
            jcrPath: this._jcrPath,
            modifiable: this._modifiable,
            modifiableTraversable: this._modifiableTraversable
        }, initialProperty);
    }
    
});

