/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Action for the admin workspace repository item: redirect to the repository workspace.
 * @private
 */
Ext.define('Ametys.plugins.repository.admin.JCRRepositoryLink',
{
    singleton: true,
    
    /**
     * Redirect to the repository workspace.
     * @param {Ametys.ribbon.element.ui.ButtonController} controller the controller calling this function
     */
    open: function(controller)
    {
    	Ametys.openWindow(Ametys.CONTEXT_PATH + '/_repository', null, null, "_target");
    }
});
