/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button only enabled on JCR AmetysObjects.
 */
Ext.define('Ametys.plugins.repository.controller.AmetysObjectJcrController',
{
    extend: 'Ametys.repository.controller.RepositoryButtonController',
    
    constructor: function()
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.SELECTION_CHANGED, this._onMessageSelectionChanged, this);
    },
    
    /**
     * Called when the selection has changed.
     * @param {Ametys.message.Message} message The bus message.
     * @protected
     */
    _onMessageSelectionChanged: function(message)
    {
        var targets = this.getMatchingTargets();
        if (targets.length > 0)
        {
            if (targets[0].getParameters().jcrAo)
            {
            	this.enable();
            	this.setAdditionalDescription('');
            }
            else
            {
            	this.disable();
            	this.setAdditionalDescription(this.getInitialConfig('description-not-jcr') || '');
            }
        }
    },

});
