/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * The Ametys logic tree panel.
 * @private
 */
Ext.define('Ametys.plugins.repository.tree.AmetysTreePanel',  {
    extend: 'Ametys.repository.tree.JcrTreePanel',
    
    _getStore: function ()
    {
        return Ext.create('Ext.data.TreeStore', {
            model: 'Ametys.plugins.repository.tree.AmetysTreePanel.AmetysObject',
            proxy: {
                type: 'ajax',
                url: Ametys.getPluginDirectPrefix('repository') + '/repository/logic-node',
                reader: {
                    type: 'xml',
                    rootProperty: 'repository',
                    record: 'ametysObject/ametysObject'
                }
            },
            root: {
                text: "ametys:root",
                iconCls: 'a-tree-glyph ametysicon-ametys',
                id: '/',
                jcrPath: '/ametys:root',
                expanded: true
            },
            folderSort: true,
            sorters: [{
                property: 'text',
                direction: 'ASC'
            }],
            listeners: {
                beforeload: {fn: this._onBeforeLoad, scope: this}
            }
        });
    },
    
    _getDockedItems: function ()
    {
        return {
                dock: 'top',
                xtype: 'toolbar',
                layout: { 
                    type: 'hbox',
                    align: 'stretch'
                },
                items: [
                        '->',
                        {
                            // Refresh node
                            tooltip: "{{i18n PLUGINS_REPOSITORY_REFRESH_OBJECT_BTN}}",
                            handler: Ext.bind (this.refreshNode, this, [], false),
                            iconCls: 'a-btn-glyph ametysicon-arrow123 size-16',
                            cls: 'a-btn-light'
                        }
                ]
            }
    },
    
    /**
     * Add additional parameters to the Operation before loading the store.
     * @param {Ext.data.TreeStore} store The tree store.
     * @param {Ext.data.Operation} operation The operation object that will be passed to the Proxy to load the Store.
     * @param {Object} eOpts Options added to the addListener
     * @private
     */
    _onBeforeLoad: function(store, operation, eOpts)
    {
        var node = operation.node;
        if (node != null && !node.isRoot())
        {
            operation.setParams({id: node.getId()});
        }
    },
    
    /**
     * Get an object by its JCR path (even if not loaded in the tree).
     * @param {String} jcrPath The object JCR path.
     * @return {Ametys.plugins.repository.tree.AmetysTreePanel.AmetysObject} The object node or null if not found.
     */
    getNodeByJcrPath: function(jcrPath)
    {
        var nodes = this.getStore().query('jcrPath', jcrPath, false, false, true);
        if (nodes.length > 0)
        {
            return nodes.getAt(0);
        }
        return null;
    },
    
    getCurrentWorkspaceName: function ()
    {
        // FIXME Use the same combo box as JCRTreePanel
        return "default";
    }
});
