/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * AmetysObject model.
 * @private
 */
Ext.define('Ametys.plugins.repository.tree.AmetysTreePanel.AmetysObject', {
    extend: 'Ext.data.TreeModel',
    
    fields: [
        {name: 'id', mapping: '@id'},
        {name: 'text', mapping: '@name'},
        {name: 'name', mapping: '@name'},
        {name: 'path', mapping: '@path'},
        {name: 'jcrPath', mapping: '@JCRPath'},
        {name: 'jcrPathWithGroups', mapping: '@JCRPathWithGroups'},
        {name: 'isModifiable', mapping: 'isModifiable', type: 'boolean'},
        {name: 'isModifiableTraversable', mapping: 'isModifiableTraversable', type: 'boolean'},
        {name: 'isLocked', mapping: 'isLocked'},
        {name: 'isLockable', mapping: 'isLockable', type: 'boolean'},
        {name: 'noChild', mapping: '@noChild', type: 'boolean'},
        {name: 'leaf', mapping: '@noChild', type: 'boolean'},
        {name: 'iconCls', defaultValue: 'a-tree-glyph ametysicon-ametys'}
    ]
});
