/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ametys.namespace('Repository', {
    query: function (xpath, convertToAmetysObject, session) {
            var session = session || Repository.session;
        
            if (convertToAmetysObject === false)
            {   
                const Query = Java.type('javax.jcr.query.Query');
                return session.getWorkspace().getQueryManager().createQuery(xpath, Query.XPATH).execute().getNodes();
            }
            else 
            {
                return Repository.resolver.query(xpath, session);
            }
        }
});

// Obsolete
function jcrXPathQuery(xpath, convertToAmetysObject) {
    Ametys.console.warn("jcrXPathQuery is obsolete. Use Repository.query instead.");
    return Repository.query(xpath, convertToAmetysObject);
}
