/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ametys.namespace('Repository', {
    registerNodeType: function(localNodeTypeName, options) {
        
        options = options || {};
        let namespace = options.namespace || "http://www.ametys.org/jcr/repository/1.0";
        let unregisterIfExists = options.unregisterIfExists !== false;
        let supertype = options.superType || "unstructured";
        let supertypeNamespace = options.supertypeNamespace || "http://www.jcp.org/jcr/nt/1.0";
        
        const NodeTypeRegistry = Java.type('org.apache.jackrabbit.core.nodetype.NodeTypeRegistry');
        
        let nodeTypeManager = Repository.session.getWorkspace().getNodeTypeManager();
        let registry = nodeTypeManager.getNodeTypeRegistry();
        
        let nameFactory = org.apache.jackrabbit.spi.commons.name.NameFactoryImpl.getInstance();
        
        let nodeTypeName = nameFactory.create(namespace, localNodeTypeName);
        
        let nodeTypeExists = registry.isRegistered(nodeTypeName);
        
        // Unregister the old node type before registering it with another declaration
        if (nodeTypeExists)
        {
            // We don't want to override the existing definition
            if (!unregisterIfExists)
            {
                return;
            }
            
            // Store current configuration to restore it after the declaration of the new node type
            const oldDisableCheckForReferencesInContentExceptionValue = NodeTypeRegistry.disableCheckForReferencesInContentException;
            
            try
            {
                // Disable temporarily check for references, as otherwise we couldn't unregister a node type that have references  
                NodeTypeRegistry.disableCheckForReferencesInContentException = true;
                registry.unregisterNodeType(nodeTypeName);
            }
            finally
            {
                // Restore old configuration value
                NodeTypeRegistry.disableCheckForReferencesInContentException = oldDisableCheckForReferencesInContentExceptionValue;
            }
        }
        
        // Register the new node type
        registry.registerNodeType(new org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl(
                nodeTypeName, 
                [nameFactory.create(supertypeNamespace, supertype)],
                [],
                false,
                false,
                false,
                false,
                null,
                [],
                []
                ));
    }
});