/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

import java.util.Map;
import java.util.Set;

import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys;
import org.ametys.core.right.ProfileAssignmentStorage.UserOrGroup;
import org.ametys.core.user.UserIdentity;

/**
 * {@link AmetysObject} that can hold its profile assignments.
 */
public interface ACLAmetysObject extends AmetysObject
{
    /**
     * Gets the allowed profiles any connected user has on the given object
     * @return a map containing allowed/denied profiles that anonymous and any connected user has on the given object
     */
    public Map<AnonymousOrAnyConnectedKeys, Set<String>> getProfilesForAnonymousAndAnyConnectedUser();
    
    /**
     * Gets the users that have allowed profiles assigned on the given object
     * @param user The user to get profiles for. Can be null to get profiles for all users that have rights
     * @return The map of allowed users with their assigned allowed/denied profiles
     */
    public Map<UserIdentity, Map<UserOrGroup, Set<String>>> getProfilesForUsers(UserIdentity user);
    
    /**
     * Gets the groups that have allowed profiles assigned on the given object
     * @param groups The group to get profiles for. Can be null to get profiles for all groups that have rights
     * @return The map of allowed/denied groups with their assigned profiles
     */
    public Map<GroupIdentity, Map<UserOrGroup, Set<String>>> getProfilesForGroups(Set<GroupIdentity> groups);
    
    /**
     * Returns true if the inheritance is disallow for this ametys object
     * @return true if the inheritance is disallow for this ametys object
     */
    public boolean isInheritanceDisallowed();
}
