/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

/**
 * Abstract class for {@link AmetysObject}.
 */
public abstract class AbstractAmetysObject implements AmetysObject
{
    @Override
    public boolean equals(Object obj)
    {
        if (obj == null)
        {
            return false;
        }
        
        if (!(obj instanceof AmetysObject))
        {
            return false;
        }
        
        AmetysObject ametysObject = (AmetysObject) obj;
        
        return getId().equals(ametysObject.getId());
    }
    
    @Override
    public int hashCode()
    {
        return getId().hashCode();
    }
    
    @Override
    public String toString()
    {
        try
        {
            StringBuilder object = new StringBuilder();

            object.append("'");
            object.append(getPath());
            object.append("' (");
            object.append(getId());
            object.append(")");
            
            return object.toString();
        }
        catch (AmetysRepositoryException e)
        {
            return super.toString();
        }
    }
}
