/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

/**
 * Common interface for all Ametys objects.
 */
public interface AmetysObject
{
    /**
     * Retrieves the name of the current object.
     * @return the name.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getName() throws AmetysRepositoryException;
    
    /**
     * Retrieves the path of the current object.
     * @return the path.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getPath() throws AmetysRepositoryException;
    
    /**
     * Retrieves the unique identifier of this AmetysObject.<br>
     * It must be unique in the whole repository and must never be null.<br>
     * It must conform to the URI syntax:<br>
     * <code>&lt;protocol&gt;://&lt;protocol-specific-part&gt;</code>
     * @return the unique identifier of this AmetysObject
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getId() throws AmetysRepositoryException;
    
    /**
     * Returns the parent object in the Ametys hierarchy.
     * @param <A> the type of the parent {@link AmetysObject}.
     * @return the parent object or <code>null</code> if current object
     *         is the root.
     * @throws AmetysRepositoryException if an error occurs.
     */
    <A extends AmetysObject> A getParent() throws AmetysRepositoryException;
    
    /**
     * Returns the path of the parent object in the Ametys hierarchy.
     * @return the path of the parent object.
     * @throws AmetysRepositoryException if an error occurs.
     */
    String getParentPath() throws AmetysRepositoryException;
    
    /**
     * Two AmetysObjects are equals if and only if their ids are equals.
     */
    @Override
    public boolean equals(Object obj);
    
    /**
     * The hashCode of an AmetysObject must be the hashCode of its id.
     */
    @Override
    public int hashCode();
}
