/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

/**
 * Exception thrown when an attempt to created a {@link AmetysObject} failed because
 * this {@link AmetysObject} already exist.
 */
public class AmetysObjectExistsException extends AmetysRepositoryException
{
    private AmetysObject _ao;
    /**
     * Constructs a new unknown data exception with the specified
     * detail message.
     * @param message The detail message. 
     */
    public AmetysObjectExistsException(String message)
    {
        super(message);
    }
    
    /**
     * Constructs a new unknown data exception with the specified
     * detail message.
     * @param message The detail message. 
     * @param ao The Ametys object
     */
    public AmetysObjectExistsException(String message, AmetysObject ao)
    {
        super(message);
        _ao = ao;
    }
    
    /**
     * Constructs a new unknown data exception with the specified
     * detail message and cause.
     * @param message The detail message.
     * @param cause The cause.
     */
    public AmetysObjectExistsException(String message, Throwable cause)
    {
        super(message, cause);
    }
    
    /**
     * Constructs a new unknown data exception with the specified
     * cause.
     * @param cause The cause.
     */
    public AmetysObjectExistsException(Throwable cause)
    {
        super(cause);
    }
    
    /**
     * Get the Ametys object responsible for this exception
     * @return The Ametys object
     */
    public AmetysObject getAmetysObject()
    {
        return _ao;
    }
}
