/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

import org.apache.avalon.framework.component.Component;

/**
 * Factory for retrieving type of {@link AmetysObject}.
 * @param <A> the actual type of {@link AmetysObject}s
 */
public interface AmetysObjectFactory<A extends AmetysObject> extends Component
{
    /**
     * Retrieves an {@link AmetysObject}, given its id.<br>
     * Id are like <code>&lt;protocol&gt;://&lt;protocol-specific-part&gt;</code>.
     * @param id the identifier.
     * @return the corresponding {@link AmetysObject}.
     * @throws AmetysRepositoryException if an error occurs.
     */
    A getAmetysObjectById(String id) throws AmetysRepositoryException;
    
    /**
     * Return true if the specified id correspond to an existing {@link AmetysObject}.
     * Id are like <code>&lt;protocol&gt;://&lt;protocol-specific-part&gt;</code>.
     * @param id the identifier.
     * @return true if the specified id correspond to an existing {@link AmetysObject}.
     * @throws AmetysRepositoryException if an error occurs.
     */
    boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException;
    
    /**
     * Returns the protocol of this factory, used to construct unique ids.
     * @return the protocol of this factory.
     */
    String getScheme();
}
