/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.ui.right.TargetToContextConvertor;

/**
 * Target to context convertor able to handle ametys object context.
 */
public class AmetysObjectTargetToContextConvertor extends StaticClientSideElement implements TargetToContextConvertor
{
    /** the ametys object resolver */
    protected AmetysObjectResolver _resolver;
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    public Object convertJSContext(Object jsContext) throws UnsupportedContextException
    {
        return _resolver.resolveById((String) jsContext);
    }

}
