/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

import java.util.Collection;
import java.util.Iterator;

/**
 * Basic implementation of an {@link AmetysObjectIterable} based on an existing {@link Collection}.
 * @param <A> the actual type of {@link AmetysObject}s
 */
public class CollectionIterable<A extends AmetysObject> implements AmetysObjectIterable<A>
{
    private Collection<A> _collection;
    
    /**
     * Creates a {@link CollectionIterable}.
     * @param collection the {@link AmetysObject}s collection
     */
    public CollectionIterable(Collection<A> collection)
    {
        _collection = collection;
    }
    
    public long getSize()
    {
        return _collection.size();
    }
    
    public AmetysObjectIterator<A> iterator()
    {
        return new CollectionIterator(_collection.iterator(), _collection.size());
    }
    
    public void close()
    {
        // nothing to do
    }
    
    class CollectionIterator implements AmetysObjectIterator<A>
    {
        private Iterator<A> _it;
        private int _pos;
        private long _size;
        
        public CollectionIterator(Iterator<A> it, long size)
        {
            _it = it;
            _size = size;
        }
        
        public boolean hasNext()
        {
            return _it.hasNext();
        }

        public A next()
        {
            _pos++;
            return _it.next();
        }

        public long getSize()
        {
            return _size;
        }
        
        public long getPosition()
        {
            return _pos;
        }
    }
}
