/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository;

import java.util.List;

/**
 * Copiable {@link AmetysObject}.
 */
public interface CopiableAmetysObject extends AmetysObject
{
    /**
     * Copy the current {@link AmetysObject} to the given object. Be careful, this method save changes.
     * @param parent The parent of the new object. Can not be null.
     * @param name Name of the new object. Can be null. If null, the new name will be get from the copied object 
     * @return the created object
     * @throws AmetysRepositoryException if an error occurs.
     */
    AmetysObject copyTo(ModifiableTraversableAmetysObject parent, String name) throws AmetysRepositoryException;
    
    /**
     * Copy the current {@link AmetysObject} to the given object if it is not in the restriction list. Be careful, this method save changes.
     * @param parent The parent of the new object. Can not be null.
     * @param name Name of the new object. Can be null. If null, the new name will be get from the copied object
     * @param restrictTo A restrict list of {@link CopiableAmetysObject} authorized to be copied
     * @return the created object
     * @throws AmetysRepositoryException if an error occurs.
     */
    AmetysObject copyTo(ModifiableTraversableAmetysObject parent, String name, List<String> restrictTo) throws AmetysRepositoryException;
}
