/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

import java.util.NoSuchElementException;

/**
 * Empty implementation of an {@link AmetysObjectIterable}.
 * @param <A> the actual type of {@link AmetysObject}s
 */
public class EmptyIterable<A extends AmetysObject> implements AmetysObjectIterable<A>
{
    /**
     * Creates a {@link EmptyIterable}.
     */
    public EmptyIterable()
    {
        // Nothing to do.
    }
    
    @Override
    public long getSize()
    {
        return 0;
    }
    
    public AmetysObjectIterator<A> iterator()
    {
        return new EmptyIterator();
    }
    
    public void close()
    {
        // nothing to do
    }
    
    class EmptyIterator implements AmetysObjectIterator<A>
    {
        @Override
        public long getPosition()
        {
            return 0;
        }
        
        @Override
        public long getSize()
        {
            return 0;
        }
        
        @Override
        public void skip(long skipNum)
        {
            // Nothing to do
        }
        
        @Override
        public boolean hasNext()
        {
            return false;
        }
        
        @Override
        public A next()
        {
            throw new NoSuchElementException();
        }
        
        public void remove()
        {
            // Nothing to do.
        }
    }
}
