/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository;

import java.util.Map;

import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;

import org.ametys.plugins.repository.provider.AmetysSession;

/**
 * Request Listener to ensure the end of JCR sessions
 */
public class JCRSessionRequestListener implements ServletRequestListener
{
    public void requestDestroyed(ServletRequestEvent event)
    {
        ServletRequest request = event.getServletRequest();
        
        @SuppressWarnings("unchecked")
        Map<String, AmetysSession> sessions = (Map<String, AmetysSession>) request.getAttribute(RepositoryConstants.JCR_SESSION_REQUEST_ATTRIBUTE);

        if (sessions != null)
        {
            for (AmetysSession session : sessions.values())
            {
                session.forceLogout();
            }
        }
    }

    public void requestInitialized(ServletRequestEvent event)
    {
        // request initialized
    }
}
