/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

import java.util.Set;

import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ModifiableProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.jcr.ACLJCRAmetysObjectHelper;

/**
 * Implementation of {@link ProfileAssignmentStorage} for {@link ModifiableACLAmetysObject}s which stores profile assignments in subnodes of the node representing this object.
 */
public class ModifiableACLAmetysObjectProfileAssignmentStorage extends ACLAmetysObjectProfileAssignmentStorage implements ModifiableProfileAssignmentStorage
{
    @Override
    public void addAllowedProfilesForAnyConnectedUser(Object object, Set<String> profileIds)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.addAllowedProfilesForAnyConnectedUser(profileIds);
    }

    @Override
    public void removeAllowedProfilesForAnyConnectedUser(Object object, Set<String> profileIds)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeAllowedProfilesForAnyConnectedUser(profileIds);
    }

    
    /* -------------------------------------- */
    /* DENIED PROFILES FOR ANY CONNECTED USER */
    /* -------------------------------------- */
    
    @Override
    public void addDeniedProfilesForAnyConnectedUser(Object object, Set<String> profileIds)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.addDeniedProfilesForAnyConnectedUser(profileIds);
    }
    
    @Override
    public void removeDeniedProfilesForAnyConnectedUser(Object object, Set<String> profileIds)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeDeniedProfilesForAnyConnectedUser(profileIds);
    }
    
    
    /* ------------------------------ */
    /* ALLOWED PROFILES FOR ANONYMOUS */
    /* ------------------------------ */
    
    @Override
    public void addAllowedProfilesForAnonymous(Object object, Set<String> profileIds)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.addAllowedProfilesForAnonymous(profileIds);
    }
    
    @Override
    public void removeAllowedProfilesForAnonymous(Object object, Set<String> profileIds)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeAllowedProfilesForAnonymous(profileIds);
    }
    
    
    /* ----------------------------- */
    /* DENIED PROFILES FOR ANONYMOUS */
    /* ----------------------------- */
    
    @Override
    public void addDeniedProfilesForAnonymous(Object object, Set<String> profileIds)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.addDeniedProfilesForAnonymous(profileIds);
    }
    
    @Override
    public void removeDeniedProfilesForAnonymous(Object object, Set<String> profileIds)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeDeniedProfilesForAnonymous(profileIds);
    }
    
    
    /* --------------------------- */
    /* MANAGEMENT OF ALLOWED USERS */
    /* --------------------------- */

    @Override
    public void addAllowedUsers(Set<UserIdentity> users, Object object, String profileId)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.addAllowedUsers(users, profileId);
    }

    @Override
    public void removeAllowedUsers(Set<UserIdentity> users, Object object, String profileId)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeAllowedUsers(users, profileId);
    }

    @Override
    public void removeAllowedUsers(Set<UserIdentity> users, Object object)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeAllowedUsers(users);
    }
    
    
    /* ---------------------------- */
    /* MANAGEMENT OF ALLOWED GROUPS */
    /* ---------------------------- */

    @Override
    public void addAllowedGroups(Set<GroupIdentity> groups, Object object, String profileId)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.addAllowedGroups(groups, profileId);
    }

    @Override
    public void removeAllowedGroups(Set<GroupIdentity> groups, Object object, String profileId)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeAllowedGroups(groups, profileId);
    }

    @Override
    public void removeAllowedGroups(Set<GroupIdentity> groups, Object object)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeAllowedGroups(groups);
    }

    
    /* ---------------------------- */
    /* MANAGEMENT OF DENIED USERS */
    /* ---------------------------- */

    @Override
    public void addDeniedUsers(Set<UserIdentity> users, Object object, String profileId)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.addDeniedUsers(users, profileId);
    }

    @Override
    public void removeDeniedUsers(Set<UserIdentity> users, Object object, String profileId)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeDeniedUsers(users, profileId);
    }

    @Override
    public void removeDeniedUsers(Set<UserIdentity> users, Object object)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeDeniedUsers(users);
    }

    
    /* ----------------------------- */
    /* MANAGEMENT OF DENIED GROUPS */
    /* ----------------------------- */

    @Override
    public void addDeniedGroups(Set<GroupIdentity> groups, Object object, String profileId)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.addDeniedGroups(groups, profileId);
    }

    @Override
    public void removeDeniedGroups(Set<GroupIdentity> groups, Object object, String profileId)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeDeniedGroups(groups, profileId);
    }

    @Override
    public void removeDeniedGroups(Set<GroupIdentity> groups, Object object)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.removeDeniedGroups(groups);
    }
    
    
    /* ------ */
    /* REMOVE */
    /* ------ */

    @Override
    public void removeProfile(String profileId)
    {
        ACLJCRAmetysObjectHelper.removeProfile(profileId);
    }
    
    @Override
    public void removeUser(UserIdentity user)
    {
        ACLJCRAmetysObjectHelper.removeUser(user);
    }
    
    @Override
    public void removeGroup(GroupIdentity group)
    {
        ACLJCRAmetysObjectHelper.removeGroup(group);
    }
    
    /* ----------- */
    /* INHERITANCE */
    /* ----------- */
    
    @Override
    public void disallowInheritance(Object object, boolean disallow)
    {
        ModifiableACLAmetysObject ametysObj = (ModifiableACLAmetysObject) object;
        ametysObj.disallowInheritance(disallow);
    }
    
    /* ------------------------------ */
    /* SUPPORT OF OBJECT AND PRIORITY */
    /* ------------------------------ */
    
    @Override
    public boolean supports(Object object)
    {
        return object instanceof ModifiableACLAmetysObject;
    }

    @Override
    public int getPriority()
    {
        return ProfileAssignmentStorage.MAX_PRIORITY;
    }
}
