/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository;

/**
 * Modifiable {@link AmetysObject}.
 */
public interface ModifiableAmetysObject extends AmetysObject
{
    /**
     * Rename the {@link AmetysObject}
     * @param newName the new name of the ametys object
     * @throws AmetysRepositoryException if an error occurs.
     */
    void rename(String newName) throws AmetysRepositoryException;
    
    /**
     * Returns true if there is pending changes.
     * @return true if there is pending changes.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public boolean needsSave() throws AmetysRepositoryException;
    
    /**
     * Persists pending changes.<br>
     * If the underlying Node is new, the Session is globally saved.
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void saveChanges() throws AmetysRepositoryException;
    
    /**
     * Discard pending changes and revert to the currently persisted version.<br>
     * @throws AmetysRepositoryException if an error occurs.
     */
    public void revertChanges() throws AmetysRepositoryException;
}
