/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository;

/**
 * {@link TraversableAmetysObject} allowing to create children.
 */
public interface ModifiableTraversableAmetysObject extends TraversableAmetysObject, ModifiableAmetysObject
{
    /**
     * Creates a child below current object.
     * @param <A> the actual type of {@link AmetysObject}.
     * @param name the name of the child, position (<code>[n]</code>) are not supported for
     * same name sibling, the child will be added at the end of the children list.
     * @param type the type of the object.
     * @return the new object created.
     * @throws AmetysRepositoryException if an error occurs.
     * @throws RepositoryIntegrityViolationException if an object with the same name already
     *         exists and same name siblings is not allowed.
     */
    <A extends AmetysObject> A createChild(String name, String type) throws AmetysRepositoryException, RepositoryIntegrityViolationException;
}
